/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.service.avatar;

import io.rocketbase.commons.config.GravatarProperties;
import io.rocketbase.commons.service.avatar.AvatarService;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;
import org.springframework.web.util.UriComponentsBuilder;

public class GravatarService
implements AvatarService {
    final GravatarProperties gravatarProperties;

    @Override
    public String getAvatar(String email) {
        if (email == null) {
            return null;
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)"https://www.gravatar.com/avatar/");
        uriBuilder.path(this.md5(email.toLowerCase()));
        uriBuilder.path(".jpg");
        uriBuilder.queryParam("s", new Object[]{this.gravatarProperties.getSize()});
        uriBuilder.queryParam("d", new Object[]{this.gravatarProperties.getImage().getUrlParam()});
        if (this.gravatarProperties.getRating() != null) {
            uriBuilder.queryParam("r", new Object[]{this.gravatarProperties.getRating().getUrlParam()});
        }
        return uriBuilder.toUriString();
    }

    private String md5(String text) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update((text == null ? "" : text).getBytes());
        return DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
    }

    @Override
    public boolean isEnabled() {
        return this.gravatarProperties.isEnabled();
    }

    public GravatarService(GravatarProperties gravatarProperties) {
        this.gravatarProperties = gravatarProperties;
    }
}

