/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.service;

import io.rocketbase.commons.service.KeyGenerator;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTokenService {
    private static final Logger log = LoggerFactory.getLogger(SimpleTokenService.class);
    private static final DateTimeFormatter DTF = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 4, SignStyle.EXCEEDS_PAD).appendValue(ChronoField.DAY_OF_YEAR, 3).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter(Locale.ENGLISH);

    public static String generateToken(String username, long expiresInMinutes) {
        return KeyGenerator.random(4) + LocalDateTime.now().plusMinutes(expiresInMinutes).format(DTF) + KeyGenerator.random(4) + ":" + username;
    }

    public static Token parseToken(String token) {
        return Token.parseString(token);
    }

    public static class Token
    implements Serializable {
        public static final String DEF_SPLITTER = ":";
        private final String username;
        private final LocalDateTime exp;

        public static Token parseString(String serialization) {
            try {
                String[] values = serialization.split("\\:", 2);
                LocalDateTime expired = null;
                if (values[0] != null && values[0].length() == 21) {
                    try {
                        expired = LocalDateTime.parse(values[0].substring(4, 17), DTF);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new Token(values[1], expired);
            }
            catch (Exception e) {
                return new Token(null, null);
            }
        }

        public boolean isValid() {
            return this.exp != null && !this.exp.isBefore(LocalDateTime.now());
        }

        public Token(String username, LocalDateTime exp) {
            this.username = username;
            this.exp = exp;
        }

        public String getUsername() {
            return this.username;
        }

        public LocalDateTime getExp() {
            return this.exp;
        }
    }
}

