/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.service;

import io.rocketbase.commons.config.AuthProperties;
import org.springframework.util.StringUtils;

public interface FeedbackActionService {
    public AuthProperties getAuthProperties();

    default public String buildActionUrl(String applicationBaseUrl, ActionType actionType, String token) {
        String result;
        String configuredUrl = null;
        switch (actionType) {
            case VERIFICATION: {
                configuredUrl = this.getAuthProperties().getVerificationUrl();
                break;
            }
            case PASSWORD_RESET: {
                configuredUrl = this.getAuthProperties().getPasswordResetUrl();
            }
        }
        if (!StringUtils.isEmpty(configuredUrl)) {
            result = configuredUrl;
        } else {
            result = applicationBaseUrl;
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            result = result + actionType.getApiPath();
        }
        result = result + (result.contains("?") ? "&" : "?");
        result = result + "verification=" + token;
        return result;
    }

    public static enum ActionType {
        VERIFICATION("/verification"),
        PASSWORD_RESET("/reset-password");

        private String apiPath;

        private ActionType(String apiPath) {
            this.apiPath = apiPath;
        }

        public String getApiPath() {
            return this.apiPath;
        }
    }
}

