/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.security;

import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.security.CommonsAuthenticationToken;
import io.rocketbase.commons.util.JwtTokenStore;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class CommonsPrincipal
implements AppUserToken,
Principal {
    private AppUserToken user;

    public CommonsPrincipal(AppUserToken user) {
        this.user = user;
    }

    public static CommonsPrincipal getCurrent() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof CommonsAuthenticationToken) {
            return ((CommonsAuthenticationToken)authentication).getPrincipal();
        }
        return null;
    }

    public static String getCurrentKeyValue(String key) {
        CommonsPrincipal current = CommonsPrincipal.getCurrent();
        if (current != null) {
            return current.getKeyValues() != null ? (String)current.getKeyValues().getOrDefault(key.toLowerCase(), null) : null;
        }
        return null;
    }

    public static JwtTokenStore getCurrentJwtTokenStore() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof CommonsAuthenticationToken) {
            return ((CommonsAuthenticationToken)authentication).getJwtTokenStore();
        }
        return null;
    }

    public static String getValidJwtToken() {
        JwtTokenStore store = CommonsPrincipal.getCurrentJwtTokenStore();
        if (store != null) {
            if (store.checkTokenNeedsRefresh(180L)) {
                store.refreshToken();
            }
            return store.getTokenBundle().getToken();
        }
        return null;
    }

    public String getId() {
        return this.user != null ? this.user.getId() : null;
    }

    public String getUsername() {
        return this.user != null ? this.user.getUsername() : null;
    }

    public String getFirstName() {
        return this.user != null ? this.user.getFirstName() : null;
    }

    public String getLastName() {
        return this.user != null ? this.user.getLastName() : null;
    }

    public String getEmail() {
        return this.user != null ? this.user.getEmail() : null;
    }

    public String getAvatar() {
        return this.user != null ? this.user.getAvatar() : null;
    }

    public List<String> getRoles() {
        return this.user != null ? this.user.getRoles() : null;
    }

    public Map<String, String> getKeyValues() {
        return this.user != null ? this.user.getKeyValues() : null;
    }

    @Override
    public String getName() {
        return this.getUsername();
    }

    public CommonsPrincipal() {
    }
}

