/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.security;

import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.security.CommonsPrincipal;
import io.rocketbase.commons.util.JwtTokenStore;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class CommonsAuthenticationToken
extends AbstractAuthenticationToken {
    private final CommonsPrincipal principal;
    private final JwtTokenStore jwtTokenStore;

    public CommonsAuthenticationToken(Collection<? extends GrantedAuthority> authorities, AppUserToken appUserToken, JwtTokenStore jwtTokenStore) {
        super(authorities);
        this.principal = new CommonsPrincipal(appUserToken);
        this.jwtTokenStore = jwtTokenStore;
    }

    public Object getCredentials() {
        return this.jwtTokenStore.getTokenBundle();
    }

    public String getUsername() {
        return this.principal.getUsername();
    }

    public CommonsPrincipal getPrincipal() {
        return this.principal;
    }

    public JwtTokenStore getJwtTokenStore() {
        return this.jwtTokenStore;
    }
}

