/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.rocketbase.commons.model.AppUserReference;
import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.model.SimpleAppUserReference;
import java.time.Instant;
import java.util.List;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public interface AppUserEntity
extends UserDetails,
AppUserToken {
    public void setId(String var1);

    public void setUsername(String var1);

    public String getPassword();

    public void setPassword(String var1);

    public void setFirstName(String var1);

    public void setLastName(String var1);

    public void setEmail(String var1);

    public void setAvatar(String var1);

    public void setRoles(List<String> var1);

    public void setEnabled(boolean var1);

    public Instant getCreated();

    public Instant getLastLogin();

    public void updateLastLogin();

    public Instant getLastTokenInvalidation();

    public void updateLastTokenInvalidation();

    default public AppUserEntity addKeyValue(String key, String value) {
        this.checkKeyValue(key, value);
        this.getKeyValues().put(key.toLowerCase(), value);
        return this;
    }

    default public void removeKeyValue(String key) {
        this.getKeyValues().remove(key.toLowerCase());
    }

    default public void checkKeyValue(String key, String value) {
        Assert.hasLength((String)key, (String)"Key must not be empty");
        Assert.state((key.length() <= 50 ? 1 : 0) != 0, (String)"Key is too long - at least 50 chars");
        Assert.hasLength((String)value, (String)"Value must not be empty");
        Assert.state((value.length() <= 4000 ? 1 : 0) != 0, (String)"Value is too long - at least 4000 chars");
    }

    @JsonIgnore
    default public AppUserReference toReference() {
        return SimpleAppUserReference.builder().id(this.getId()).username(this.getUsername()).firstName(this.getFirstName()).lastName(this.getLastName()).email(this.getEmail()).avatar(this.getAvatar()).build();
    }

    @JsonIgnore
    default public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    default public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    default public boolean isCredentialsNonExpired() {
        return true;
    }
}

