/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="auth.registration")
@Validated
public class RegistrationProperties {
    private boolean enabled = true;
    private boolean verification = true;
    private long verificationExpiration = 1440L;
    private String role = "USER";

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVerification() {
        return this.verification;
    }

    public long getVerificationExpiration() {
        return this.verificationExpiration;
    }

    public String getRole() {
        return this.role;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVerification(boolean verification) {
        this.verification = verification;
    }

    public void setVerificationExpiration(long verificationExpiration) {
        this.verificationExpiration = verificationExpiration;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationProperties)) {
            return false;
        }
        RegistrationProperties other = (RegistrationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isVerification() != other.isVerification()) {
            return false;
        }
        if (this.getVerificationExpiration() != other.getVerificationExpiration()) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistrationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isVerification() ? 79 : 97);
        long $verificationExpiration = this.getVerificationExpiration();
        result = result * 59 + (int)($verificationExpiration >>> 32 ^ $verificationExpiration);
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    public String toString() {
        return "RegistrationProperties(enabled=" + this.isEnabled() + ", verification=" + this.isVerification() + ", verificationExpiration=" + this.getVerificationExpiration() + ", role=" + this.getRole() + ")";
    }
}

