/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="auth.jwt")
public class JwtProperties {
    private String header = "Authorization";
    private String tokenPrefix = "Bearer ";
    private String uriParam = "token";
    @NotNull
    private String secret;
    private long accessTokenExpiration = 60L;
    private long refreshTokenExpiration = 43200L;

    public String getHeader() {
        return this.header;
    }

    public String getTokenPrefix() {
        return this.tokenPrefix;
    }

    public String getUriParam() {
        return this.uriParam;
    }

    public String getSecret() {
        return this.secret;
    }

    public long getAccessTokenExpiration() {
        return this.accessTokenExpiration;
    }

    public long getRefreshTokenExpiration() {
        return this.refreshTokenExpiration;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setTokenPrefix(String tokenPrefix) {
        this.tokenPrefix = tokenPrefix;
    }

    public void setUriParam(String uriParam) {
        this.uriParam = uriParam;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAccessTokenExpiration(long accessTokenExpiration) {
        this.accessTokenExpiration = accessTokenExpiration;
    }

    public void setRefreshTokenExpiration(long refreshTokenExpiration) {
        this.refreshTokenExpiration = refreshTokenExpiration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtProperties)) {
            return false;
        }
        JwtProperties other = (JwtProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$tokenPrefix = this.getTokenPrefix();
        String other$tokenPrefix = other.getTokenPrefix();
        if (this$tokenPrefix == null ? other$tokenPrefix != null : !this$tokenPrefix.equals(other$tokenPrefix)) {
            return false;
        }
        String this$uriParam = this.getUriParam();
        String other$uriParam = other.getUriParam();
        if (this$uriParam == null ? other$uriParam != null : !this$uriParam.equals(other$uriParam)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        if (this.getAccessTokenExpiration() != other.getAccessTokenExpiration()) {
            return false;
        }
        return this.getRefreshTokenExpiration() == other.getRefreshTokenExpiration();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $tokenPrefix = this.getTokenPrefix();
        result = result * 59 + ($tokenPrefix == null ? 43 : $tokenPrefix.hashCode());
        String $uriParam = this.getUriParam();
        result = result * 59 + ($uriParam == null ? 43 : $uriParam.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        long $accessTokenExpiration = this.getAccessTokenExpiration();
        result = result * 59 + (int)($accessTokenExpiration >>> 32 ^ $accessTokenExpiration);
        long $refreshTokenExpiration = this.getRefreshTokenExpiration();
        result = result * 59 + (int)($refreshTokenExpiration >>> 32 ^ $refreshTokenExpiration);
        return result;
    }

    public String toString() {
        return "JwtProperties(header=" + this.getHeader() + ", tokenPrefix=" + this.getTokenPrefix() + ", uriParam=" + this.getUriParam() + ", secret=" + this.getSecret() + ", accessTokenExpiration=" + this.getAccessTokenExpiration() + ", refreshTokenExpiration=" + this.getRefreshTokenExpiration() + ")";
    }
}

