/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="auth.gravatar")
public class GravatarProperties {
    private boolean enabled = true;
    private Integer size = 160;
    private DefaultImage image = DefaultImage.RETRO;
    private ImageRating rating = null;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getSize() {
        return this.size;
    }

    public DefaultImage getImage() {
        return this.image;
    }

    public ImageRating getRating() {
        return this.rating;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setImage(DefaultImage image) {
        this.image = image;
    }

    public void setRating(ImageRating rating) {
        this.rating = rating;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GravatarProperties)) {
            return false;
        }
        GravatarProperties other = (GravatarProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        DefaultImage this$image = this.getImage();
        DefaultImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)((Object)this$image)).equals((Object)other$image)) {
            return false;
        }
        ImageRating this$rating = this.getRating();
        ImageRating other$rating = other.getRating();
        return !(this$rating == null ? other$rating != null : !((Object)((Object)this$rating)).equals((Object)other$rating));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GravatarProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        DefaultImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)((Object)$image)).hashCode());
        ImageRating $rating = this.getRating();
        result = result * 59 + ($rating == null ? 43 : ((Object)((Object)$rating)).hashCode());
        return result;
    }

    public String toString() {
        return "GravatarProperties(enabled=" + this.isEnabled() + ", size=" + this.getSize() + ", image=" + (Object)((Object)this.getImage()) + ", rating=" + (Object)((Object)this.getRating()) + ")";
    }

    public static enum ImageRating {
        G,
        PG,
        R,
        X;


        public String getUrlParam() {
            return this.name().toLowerCase();
        }
    }

    public static enum DefaultImage {
        NOT_FOUND,
        MM,
        IDENTICON,
        MONSTERID,
        WAVATAR,
        RETRO,
        ROBOHASH,
        BLANK;


        public String getUrlParam() {
            return NOT_FOUND.equals((Object)this) ? "404" : this.name().toLowerCase();
        }
    }
}

