/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="auth")
public class AuthProperties {
    @NotEmpty
    private String roleAdmin = "ADMIN";
    @NotEmpty
    private String roleUser = "USER";
    @NotEmpty
    private String tokenSecret = "E*iqzFiW#kSmAo8rO^V8%DRlQ#1f&B$i";
    private int userCacheTime = 30;
    private String baseUrl = "http://localhost:8080";
    private String prefix = "";
    private String verificationUrl = null;
    private String passwordResetUrl = null;
    private long passwordResetExpiration = 60L;

    protected static String transferPrefix(String prefix) {
        String result = "";
        if (!StringUtils.isEmpty((Object)prefix) && !prefix.equals("/")) {
            result = prefix;
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
        }
        return result;
    }

    public static String[] getAllPublicRestEndpointPaths(String prefix) {
        String prefixPath = AuthProperties.transferPrefix(prefix);
        return new String[]{prefixPath + "/auth/login", prefixPath + "/auth/forgot-password", prefixPath + "/auth/reset-password", prefixPath + "/auth/validate/*", prefixPath + "/auth/register", prefixPath + "/auth/verify"};
    }

    public static String[] getAllAuthenticatedRestEndpointPaths(String prefix) {
        String prefixPath = AuthProperties.transferPrefix(prefix);
        return new String[]{prefixPath + "/auth/refresh", prefixPath + "/auth/update-profile", prefixPath + "/auth/change-password"};
    }

    public static String[] getAllApiRestEndpointPaths(String prefix) {
        String prefixPath = AuthProperties.transferPrefix(prefix);
        return new String[]{prefixPath + "/api/user-search/*", prefixPath + "/api/user/*"};
    }

    public String getRoleAdmin() {
        return this.roleAdmin;
    }

    public String getRoleUser() {
        return this.roleUser;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public int getUserCacheTime() {
        return this.userCacheTime;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getVerificationUrl() {
        return this.verificationUrl;
    }

    public String getPasswordResetUrl() {
        return this.passwordResetUrl;
    }

    public long getPasswordResetExpiration() {
        return this.passwordResetExpiration;
    }

    public void setRoleAdmin(String roleAdmin) {
        this.roleAdmin = roleAdmin;
    }

    public void setRoleUser(String roleUser) {
        this.roleUser = roleUser;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void setUserCacheTime(int userCacheTime) {
        this.userCacheTime = userCacheTime;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setVerificationUrl(String verificationUrl) {
        this.verificationUrl = verificationUrl;
    }

    public void setPasswordResetUrl(String passwordResetUrl) {
        this.passwordResetUrl = passwordResetUrl;
    }

    public void setPasswordResetExpiration(long passwordResetExpiration) {
        this.passwordResetExpiration = passwordResetExpiration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthProperties)) {
            return false;
        }
        AuthProperties other = (AuthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$roleAdmin = this.getRoleAdmin();
        String other$roleAdmin = other.getRoleAdmin();
        if (this$roleAdmin == null ? other$roleAdmin != null : !this$roleAdmin.equals(other$roleAdmin)) {
            return false;
        }
        String this$roleUser = this.getRoleUser();
        String other$roleUser = other.getRoleUser();
        if (this$roleUser == null ? other$roleUser != null : !this$roleUser.equals(other$roleUser)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
            return false;
        }
        if (this.getUserCacheTime() != other.getUserCacheTime()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$verificationUrl = this.getVerificationUrl();
        String other$verificationUrl = other.getVerificationUrl();
        if (this$verificationUrl == null ? other$verificationUrl != null : !this$verificationUrl.equals(other$verificationUrl)) {
            return false;
        }
        String this$passwordResetUrl = this.getPasswordResetUrl();
        String other$passwordResetUrl = other.getPasswordResetUrl();
        if (this$passwordResetUrl == null ? other$passwordResetUrl != null : !this$passwordResetUrl.equals(other$passwordResetUrl)) {
            return false;
        }
        return this.getPasswordResetExpiration() == other.getPasswordResetExpiration();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $roleAdmin = this.getRoleAdmin();
        result = result * 59 + ($roleAdmin == null ? 43 : $roleAdmin.hashCode());
        String $roleUser = this.getRoleUser();
        result = result * 59 + ($roleUser == null ? 43 : $roleUser.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        result = result * 59 + this.getUserCacheTime();
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $verificationUrl = this.getVerificationUrl();
        result = result * 59 + ($verificationUrl == null ? 43 : $verificationUrl.hashCode());
        String $passwordResetUrl = this.getPasswordResetUrl();
        result = result * 59 + ($passwordResetUrl == null ? 43 : $passwordResetUrl.hashCode());
        long $passwordResetExpiration = this.getPasswordResetExpiration();
        result = result * 59 + (int)($passwordResetExpiration >>> 32 ^ $passwordResetExpiration);
        return result;
    }

    public String toString() {
        return "AuthProperties(roleAdmin=" + this.getRoleAdmin() + ", roleUser=" + this.getRoleUser() + ", tokenSecret=" + this.getTokenSecret() + ", userCacheTime=" + this.getUserCacheTime() + ", baseUrl=" + this.getBaseUrl() + ", prefix=" + this.getPrefix() + ", verificationUrl=" + this.getVerificationUrl() + ", passwordResetUrl=" + this.getPasswordResetUrl() + ", passwordResetExpiration=" + this.getPasswordResetExpiration() + ")";
    }
}

