/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.adapters;

import io.rocketbase.commons.dto.authentication.LoginRequest;
import io.rocketbase.commons.dto.authentication.LoginResponse;
import io.rocketbase.commons.exception.TokenRefreshException;
import io.rocketbase.commons.resource.BaseRestResource;
import io.rocketbase.commons.resource.LoginResource;
import io.rocketbase.commons.util.JwtTokenStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class AuthClientLoginRequestFactory
extends HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
BaseRestResource {
    private static final Logger log = LoggerFactory.getLogger(AuthClientLoginRequestFactory.class);
    private final String baseAuthApiUrl;
    private final String username;
    private final String password;
    private JwtTokenStore jwtTokenStore;

    public AuthClientLoginRequestFactory(HttpClient httpClient, String baseAuthApiUrl, String username, String password) {
        super(httpClient);
        this.baseAuthApiUrl = baseAuthApiUrl;
        this.username = username;
        this.password = password;
    }

    public AuthClientLoginRequestFactory(String baseAuthApiUrl, String username, String password) {
        this.baseAuthApiUrl = baseAuthApiUrl;
        this.username = username;
        this.password = password;
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
        JwtTokenStore jwtTokenStore = this.getJwtTokenStore();
        if (jwtTokenStore.checkTokenNeedsRefresh()) {
            try {
                jwtTokenStore.refreshToken();
            }
            catch (TokenRefreshException e) {
                this.refreshJwtTokenStore();
            }
        }
        request.setHeader(jwtTokenStore.getHeaderName(), jwtTokenStore.getTokenHeader());
    }

    private JwtTokenStore getJwtTokenStore() {
        if (this.jwtTokenStore == null) {
            this.refreshJwtTokenStore();
        }
        return this.jwtTokenStore;
    }

    private void refreshJwtTokenStore() {
        LoginResponse loginResponse = new LoginResource(this.baseAuthApiUrl).login(new LoginRequest(this.username, this.password));
        this.jwtTokenStore = new JwtTokenStore(this.baseAuthApiUrl, loginResponse.getJwtTokenBundle());
        if (log.isDebugEnabled()) {
            log.debug("logged with user: {}", (Object)this.username);
        }
    }
}

