/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.jpa;

import jakarta.persistence.Embeddable;
import jakarta.persistence.Lob;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BlobProxy;

@Embeddable
public class NamedBlob {
    public String name;
    @Lob
    public Blob contents;
    public String mimeType;

    public NamedBlob() {
    }

    public NamedBlob(String name, String mimeType, Blob contents) {
        this.name = name;
        this.mimeType = mimeType;
        this.contents = contents;
    }

    public NamedBlob(String name, String mimeType, String contents) {
        this(name, mimeType, contents.getBytes(StandardCharsets.UTF_8));
    }

    public NamedBlob(String name, String mimeType, byte[] contents) {
        this(name, mimeType, BlobProxy.generateProxy((byte[])contents));
    }

    public NamedBlob(String name, String mimeType, InputStream contents, long length) {
        this(name, mimeType, BlobProxy.generateProxy((InputStream)contents, (long)length));
    }

    public long length() {
        try {
            return this.contents != null ? this.contents.length() : 0L;
        }
        catch (SQLException e) {
            return 0L;
        }
    }
}

