/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.barcode.runtime;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Futures {
    private Futures() {
    }

    static <T> Supplier<T> toSupplier(final CompletableFuture<T> fu) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return fu.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new TemplateException((Throwable)e);
                }
            }
        };
    }

    static CompletionStage<Map<String, Object>> evaluateParams(Map<String, Expression> parameters, ResolutionContext resolutionContext) {
        if (parameters.size() == 1) {
            Map.Entry<String, Expression> entry = parameters.entrySet().iterator().next();
            if (entry.getValue().isLiteral()) {
                return CompletedStage.of(Futures.singleValueMap(entry.getKey(), entry.getValue().getLiteral()));
            }
            return resolutionContext.evaluate(entry.getValue()).thenApply(v -> Futures.singleValueMap((String)entry.getKey(), v));
        }
        ArrayList asyncResults = new ArrayList(parameters.size());
        for (Map.Entry<String, Expression> e2 : parameters.entrySet()) {
            if (e2.getValue().isLiteral()) continue;
            asyncResults.add(Map.entry(e2.getKey(), resolutionContext.evaluate(e2.getValue()).toCompletableFuture()));
        }
        if (asyncResults.isEmpty()) {
            return CompletedStage.of(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Expression)e.getValue()).getLiteral())));
        }
        if (asyncResults.size() == 1) {
            return ((CompletableFuture)((Map.Entry)asyncResults.get(0)).getValue()).thenApply(v -> {
                try {
                    return Futures.singleValueMap(parameters, (Map.Entry)asyncResults.get(0));
                }
                catch (InterruptedException | ExecutionException e1) {
                    throw new CompletionException(e1);
                }
            });
        }
        CompletableFuture<Map<String, Object>> result = new CompletableFuture<Map<String, Object>>();
        CompletableFuture.allOf((CompletableFuture[])asyncResults.stream().map(Map.Entry::getValue).toArray(CompletableFuture[]::new)).whenComplete((v, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                HashMap<String, Object> values = new HashMap<String, Object>();
                int j = 0;
                try {
                    for (Map.Entry entry : parameters.entrySet()) {
                        if (((Expression)entry.getValue()).isLiteral()) {
                            values.put((String)entry.getKey(), ((Expression)entry.getValue()).getLiteral());
                            continue;
                        }
                        values.put((String)entry.getKey(), ((CompletableFuture)((Map.Entry)asyncResults.get(j++)).getValue()).get());
                    }
                    result.complete(values);
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    private static Map<String, Object> singleValueMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    private static Map<String, Object> singleValueMap(Map<String, Expression> parameters, Map.Entry<String, CompletableFuture<Object>> value) throws InterruptedException, ExecutionException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Expression> param : parameters.entrySet()) {
            if (param.getValue().isLiteral()) {
                map.put(param.getKey(), param.getValue().getLiteral());
                continue;
            }
            map.put(value.getKey(), value.getValue().get());
        }
        return map;
    }
}

