/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.quarkiverse.openfga.client.api.ExpectedStatus;
import io.quarkiverse.openfga.client.api.Queries;
import io.quarkiverse.openfga.client.api.Vars;
import io.quarkiverse.openfga.client.api.VertxWebClientFactory;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.TypeDefinitions;
import io.quarkiverse.openfga.client.model.dto.CheckBody;
import io.quarkiverse.openfga.client.model.dto.CheckResponse;
import io.quarkiverse.openfga.client.model.dto.CreateStoreRequest;
import io.quarkiverse.openfga.client.model.dto.CreateStoreResponse;
import io.quarkiverse.openfga.client.model.dto.ExpandBody;
import io.quarkiverse.openfga.client.model.dto.ExpandResponse;
import io.quarkiverse.openfga.client.model.dto.GetStoreResponse;
import io.quarkiverse.openfga.client.model.dto.HealthzResponse;
import io.quarkiverse.openfga.client.model.dto.ListObjectsBody;
import io.quarkiverse.openfga.client.model.dto.ListObjectsResponse;
import io.quarkiverse.openfga.client.model.dto.ListStoresResponse;
import io.quarkiverse.openfga.client.model.dto.ReadAssertionsResponse;
import io.quarkiverse.openfga.client.model.dto.ReadAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.ReadAuthorizationModelsResponse;
import io.quarkiverse.openfga.client.model.dto.ReadBody;
import io.quarkiverse.openfga.client.model.dto.ReadChangesResponse;
import io.quarkiverse.openfga.client.model.dto.ReadResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAssertionsRequest;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.WriteBody;
import io.quarkiverse.openfga.client.model.dto.WriteResponse;
import io.quarkiverse.openfga.runtime.config.OpenFGAConfig;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.HttpHeaders;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.WebClient;
import io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate;
import io.vertx.mutiny.ext.web.codec.BodyCodec;
import io.vertx.mutiny.uritemplate.UriTemplate;
import io.vertx.mutiny.uritemplate.Variables;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class API
implements Closeable {
    private final WebClient webClient;
    private final Optional<Credentials> credentials;
    private final ObjectMapper objectMapper;
    private static final String APPLICATION_JSON = "application/json";
    private static final String PAGE_SIZE_PARAM = "page_size";
    private static final String CONT_TOKEN_PARAM = "continuation_token";
    private static final String STORE_ID_PARAM = "store_id";
    private static final String AUTH_MODEL_ID_PARAM = "authorization_model_id";
    private static final String TYPE_PARAM = "type";
    private static final String ID_PARAM = "id";
    private static final String FULL_QUERY_PARAM = "query";
    private static final UriTemplate STORES_URI = UriTemplate.of((String)"/stores{?query*}");
    private static final UriTemplate STORE_URI = UriTemplate.of((String)"/stores/{store_id}");
    private static final UriTemplate ASSERTIONS_URI = UriTemplate.of((String)"/stores/{store_id}/assertions/{authorization_model_id}");
    private static final UriTemplate AUTH_MODELS_URI = UriTemplate.of((String)"/stores/{store_id}/authorization-models{?query*}");
    private static final UriTemplate AUTH_MODEL_URI = UriTemplate.of((String)"/stores/{store_id}/authorization-models/{id}");
    private static final UriTemplate CHANGES_URI = UriTemplate.of((String)"/stores/{store_id}/changes");
    private static final UriTemplate CHECK_URI = UriTemplate.of((String)"/stores/{store_id}/check");
    private static final UriTemplate EXPAND_URI = UriTemplate.of((String)"/stores/{store_id}/expand");
    private static final UriTemplate LIST_OBJECTS_URI = UriTemplate.of((String)"/stores/{store_id}/list-objects");
    private static final UriTemplate READ_URI = UriTemplate.of((String)"/stores/{store_id}/read");
    private static final UriTemplate WRITE_URI = UriTemplate.of((String)"/stores/{store_id}/write");
    private static final UriTemplate HEALTH_URI = UriTemplate.of((String)"/healthz");

    public API(OpenFGAConfig config, boolean globalTrustAll, boolean tracingEnabled, Vertx vertx) {
        this(VertxWebClientFactory.create(config, globalTrustAll, tracingEnabled, vertx), config.sharedKey.map(TokenCredentials::new));
    }

    public API(WebClient webClient, Optional<Credentials> credentials) {
        this.webClient = webClient;
        this.credentials = credentials;
        this.objectMapper = API.createObjectMapper();
    }

    @Override
    public void close() {
        this.webClient.close();
    }

    public TypeDefinitions parseModel(String modelJSON) throws IOException {
        return (TypeDefinitions)this.objectMapper.readValue(modelJSON, TypeDefinitions.class);
    }

    public List<TupleKey> parseTuples(String modelJSON) throws IOException {
        return (List)this.objectMapper.readValue(modelJSON, (TypeReference)new TypeReference<List<TupleKey>>(){});
    }

    public Uni<ListStoresResponse> listStores(@Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.execute(this.request("List Stores", HttpMethod.GET, STORES_URI, Vars.vars(), Queries.query(PAGE_SIZE_PARAM, pageSize, CONT_TOKEN_PARAM, continuationToken)), ExpectedStatus.OK, ListStoresResponse.class);
    }

    public Uni<CreateStoreResponse> createStore(CreateStoreRequest body) {
        return this.execute(this.request("Create Store", HttpMethod.POST, STORES_URI, Vars.vars()), body, ExpectedStatus.CREATED, CreateStoreResponse.class);
    }

    public Uni<GetStoreResponse> getStore(String storeId) {
        return this.execute(this.request("Get Store", HttpMethod.GET, STORE_URI, Vars.vars(STORE_ID_PARAM, storeId)), ExpectedStatus.OK, GetStoreResponse.class);
    }

    public Uni<Void> deleteStore(String storeId) {
        return this.execute(this.request("Delete Store", HttpMethod.DELETE, STORE_URI, Vars.vars(STORE_ID_PARAM, storeId)), ExpectedStatus.NO_CONTENT);
    }

    public Uni<ReadAssertionsResponse> readAssertions(String storeId, @Nullable String authorizationModelId) {
        return this.execute(this.request("Read Assertions", HttpMethod.GET, ASSERTIONS_URI, Vars.vars(STORE_ID_PARAM, storeId, AUTH_MODEL_ID_PARAM, authorizationModelId)), ExpectedStatus.OK, ReadAssertionsResponse.class);
    }

    public Uni<Void> writeAssertions(String storeId, String authorizationModelId, WriteAssertionsRequest body) {
        return this.execute(this.request("Write Assertions", HttpMethod.PUT, ASSERTIONS_URI, Vars.vars(STORE_ID_PARAM, storeId, AUTH_MODEL_ID_PARAM, authorizationModelId)), body, ExpectedStatus.NO_CONTENT);
    }

    public Uni<ReadAuthorizationModelsResponse> readAuthorizationModels(String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.execute(this.request("Read Auth Models", HttpMethod.GET, AUTH_MODELS_URI, Vars.vars(STORE_ID_PARAM, storeId), Queries.query(PAGE_SIZE_PARAM, pageSize, CONT_TOKEN_PARAM, continuationToken)), ExpectedStatus.OK, ReadAuthorizationModelsResponse.class);
    }

    public Uni<WriteAuthorizationModelResponse> writeAuthorizationModel(String storeId, TypeDefinitions typeDefinitions) {
        return this.execute(this.request("Write Auth Model", HttpMethod.POST, AUTH_MODELS_URI, Vars.vars(STORE_ID_PARAM, storeId)), typeDefinitions, ExpectedStatus.CREATED, WriteAuthorizationModelResponse.class);
    }

    public Uni<ReadAuthorizationModelResponse> readAuthorizationModel(String storeId, @Nullable String id) {
        return this.execute(this.request("Read Auth Model", HttpMethod.GET, AUTH_MODEL_URI, Vars.vars(STORE_ID_PARAM, storeId, ID_PARAM, id)), ExpectedStatus.OK, ReadAuthorizationModelResponse.class);
    }

    public Uni<ReadChangesResponse> readChanges(String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.execute(this.request("Read Changes", HttpMethod.GET, CHANGES_URI, Vars.vars(STORE_ID_PARAM, storeId), Queries.query(TYPE_PARAM, type, PAGE_SIZE_PARAM, pageSize, CONT_TOKEN_PARAM, continuationToken)), ExpectedStatus.OK, ReadChangesResponse.class);
    }

    public Uni<CheckResponse> check(String storeId, CheckBody body) {
        return this.execute(this.request("Check", HttpMethod.POST, CHECK_URI, Vars.vars(STORE_ID_PARAM, storeId)), body, ExpectedStatus.OK, CheckResponse.class);
    }

    public Uni<ExpandResponse> expand(String storeId, ExpandBody body) {
        return this.execute(this.request("Expand", HttpMethod.POST, EXPAND_URI, Vars.vars(STORE_ID_PARAM, storeId)), body, ExpectedStatus.OK, ExpandResponse.class);
    }

    public Uni<ListObjectsResponse> listObjects(String storeId, ListObjectsBody body) {
        return this.execute(this.request("List Objects", HttpMethod.POST, LIST_OBJECTS_URI, Vars.vars(STORE_ID_PARAM, storeId)), body, ExpectedStatus.OK, ListObjectsResponse.class);
    }

    public Uni<ReadResponse> read(String storeId, ReadBody body) {
        return this.execute(this.request("Read", HttpMethod.POST, READ_URI, Vars.vars(STORE_ID_PARAM, storeId)), body, ExpectedStatus.OK, ReadResponse.class);
    }

    public Uni<WriteResponse> write(String storeId, WriteBody body) {
        return this.execute(this.request("Write", HttpMethod.POST, WRITE_URI, Vars.vars(STORE_ID_PARAM, storeId)), body, ExpectedStatus.OK, WriteResponse.class);
    }

    public Uni<HealthzResponse> health() {
        return this.execute(this.request("Health Check", HttpMethod.GET, HEALTH_URI, Vars.vars()), ExpectedStatus.OK, HealthzResponse.class);
    }

    private <B, R> Uni<R> execute(HttpRequest<Buffer> request, B body, ExpectedStatus expectedStatus, Class<R> responseType) {
        return Uni.createFrom().deferred(Unchecked.supplier(() -> this.prepare(request, expectedStatus).putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON).expect(ResponsePredicate.JSON).putHeader(HttpHeaders.CONTENT_TYPE.toString(), APPLICATION_JSON).sendBuffer(Buffer.buffer((String)this.objectMapper.writeValueAsString(body))))).onItem().transform(Unchecked.function(response -> this.objectMapper.readValue(response.bodyAsString(), responseType)));
    }

    private <B> Uni<Void> execute(HttpRequest<Buffer> request, B body, ExpectedStatus expectedStatus) {
        return Uni.createFrom().deferred(Unchecked.supplier(() -> this.prepare(request, expectedStatus).putHeader(HttpHeaders.CONTENT_TYPE.toString(), APPLICATION_JSON).sendBuffer(Buffer.buffer((String)this.objectMapper.writeValueAsString(body))).replaceWithVoid()));
    }

    private <R> Uni<R> execute(HttpRequest<Buffer> request, ExpectedStatus expectedStatus, Class<R> responseType) {
        return this.prepare(request, expectedStatus).putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON).expect(ResponsePredicate.JSON).as(BodyCodec.buffer()).send().onItem().transform(Unchecked.function(response -> this.objectMapper.readValue(response.bodyAsString(), responseType)));
    }

    private Uni<Void> execute(HttpRequest<Buffer> request, ExpectedStatus expectedStatus) {
        return this.prepare(request, expectedStatus).send().replaceWithVoid();
    }

    private <R> HttpRequest<R> prepare(HttpRequest<R> request, ExpectedStatus expectedStatus) {
        this.credentials.ifPresent(arg_0 -> request.authentication(arg_0));
        return request.expect(expectedStatus.responsePredicate);
    }

    private HttpRequest<Buffer> request(String operationName, HttpMethod method, UriTemplate uriTemplate, Variables variables, Map<String, String> query) {
        variables.set(FULL_QUERY_PARAM, query);
        return this.request(operationName, method, uriTemplate, variables);
    }

    private HttpRequest<Buffer> request(String operationName, HttpMethod method, UriTemplate uriTemplate, Variables variables) {
        RequestOptions options = new RequestOptions().setURI(uriTemplate.expandToString(variables)).setTraceOperation(String.format("FGA | %s", operationName.toUpperCase()));
        return this.webClient.request(method, options);
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

