/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.ContextualTupleKeys;
import io.quarkiverse.openfga.client.model.PartialTupleKey;
import io.quarkiverse.openfga.client.model.Tuple;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.TupleKeys;
import io.quarkiverse.openfga.client.model.UsersetTree;
import io.quarkiverse.openfga.client.model.dto.CheckBody;
import io.quarkiverse.openfga.client.model.dto.CheckResponse;
import io.quarkiverse.openfga.client.model.dto.ExpandBody;
import io.quarkiverse.openfga.client.model.dto.ExpandResponse;
import io.quarkiverse.openfga.client.model.dto.ListObjectsBody;
import io.quarkiverse.openfga.client.model.dto.ListObjectsResponse;
import io.quarkiverse.openfga.client.model.dto.ReadAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.ReadBody;
import io.quarkiverse.openfga.client.model.dto.WriteBody;
import io.quarkiverse.openfga.client.model.dto.WriteResponse;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AuthorizationModelClient {
    private final API api;
    private final Uni<String> storeId;
    private final String authorizationModelId;

    public AuthorizationModelClient(API api, Uni<String> storeId, @Nullable String authorizationModelId) {
        this.api = api;
        this.storeId = storeId;
        this.authorizationModelId = authorizationModelId;
    }

    public Uni<AuthorizationModel> get() {
        return this.storeId.flatMap(storeId -> this.api.readAuthorizationModel((String)storeId, this.authorizationModelId)).map(ReadAuthorizationModelResponse::getAuthorizationModel);
    }

    public Uni<Boolean> check(TupleKey tupleKey, @Nullable ContextualTupleKeys contextualTupleKeys) {
        return this.storeId.flatMap(storeId -> this.api.check((String)storeId, new CheckBody(tupleKey, contextualTupleKeys, this.authorizationModelId, null))).map(CheckResponse::getAllowed);
    }

    public Uni<UsersetTree> expand(TupleKey tupleKey) {
        return this.storeId.flatMap(storeId -> this.api.expand((String)storeId, new ExpandBody(tupleKey, this.authorizationModelId))).map(ExpandResponse::getTree);
    }

    public Uni<List<String>> listObjects(String type, @Nullable String relation, String user, @Nullable List<TupleKey> contextualTupleKeys) {
        return this.storeId.flatMap(storeId -> this.api.listObjects((String)storeId, new ListObjectsBody(this.authorizationModelId, type, relation, user, contextualTupleKeys != null ? new ContextualTupleKeys(contextualTupleKeys) : null))).map(ListObjectsResponse::getObjects);
    }

    public Uni<PaginatedList<Tuple>> queryTuples(PartialTupleKey tupleKey, @Nullable Integer pageSize, @Nullable String pagingToken) {
        return this.storeId.flatMap(storeId -> this.api.read((String)storeId, new ReadBody(tupleKey, this.authorizationModelId, pageSize, pagingToken))).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> queryAllTuples(PartialTupleKey tupleKey) {
        return this.queryAllTuples(tupleKey, null);
    }

    public Uni<List<Tuple>> queryAllTuples(PartialTupleKey tupleKey, @Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, (currentPageSize, currentToken) -> this.queryTuples(tupleKey, (Integer)currentPageSize, (String)currentToken));
    }

    public Uni<PaginatedList<Tuple>> readTuples(@Nullable Integer pageSize, @Nullable String pagingToken) {
        return this.storeId.flatMap(storeId -> this.api.read((String)storeId, new ReadBody(null, this.authorizationModelId, pageSize, pagingToken))).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> readAllTuples() {
        return this.readAllTuples(null);
    }

    public Uni<List<Tuple>> readAllTuples(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::readTuples);
    }

    public Uni<Void> write(TupleKey tupleKey) {
        return this.write(List.of(tupleKey), null).replaceWithVoid();
    }

    public Uni<Map<String, Object>> write(@Nullable List<TupleKey> writes, @Nullable List<TupleKey> deletes) {
        TupleKeys writeKeys = TupleKeys.of(writes);
        TupleKeys deleteKeys = TupleKeys.of(deletes);
        return this.storeId.flatMap(storeId -> this.api.write((String)storeId, new WriteBody(writeKeys, deleteKeys, this.authorizationModelId))).map(WriteResponse::getValues);
    }
}

