/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.AuthorizationModelClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.TypeDefinition;
import io.quarkiverse.openfga.client.model.TypeDefinitions;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.annotation.Nullable;

public class AuthorizationModelsClient {
    private final API api;
    private final Uni<String> storeId;

    public AuthorizationModelsClient(API api, Uni<String> storeId) {
        this.api = api;
        this.storeId = storeId;
    }

    public Uni<PaginatedList<AuthorizationModel>> list(@Nullable Integer pageSize, @Nullable String pagingToken) {
        return this.storeId.flatMap(storeId -> this.api.readAuthorizationModels((String)storeId, pageSize, pagingToken)).map(res -> new PaginatedList(res.getAuthorizationModels(), res.getContinuationToken()));
    }

    public Uni<List<AuthorizationModel>> listAll() {
        return this.listAll(null);
    }

    public Uni<List<AuthorizationModel>> listAll(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::list);
    }

    public Uni<String> create(List<TypeDefinition> typeDefinitions) {
        return this.create(new TypeDefinitions(typeDefinitions));
    }

    public Uni<String> create(TypeDefinitions typeDefinitions) {
        return this.storeId.flatMap(storeId -> this.api.writeAuthorizationModel((String)storeId, typeDefinitions)).map(WriteAuthorizationModelResponse::getAuthorizationModelId);
    }

    public AuthorizationModelClient model(String authorizationModelId) {
        return new AuthorizationModelClient(this.api, this.storeId, authorizationModelId);
    }

    public AuthorizationModelClient defaultModel() {
        return new AuthorizationModelClient(this.api, this.storeId, null);
    }
}

