/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.runtime.health;

import io.quarkiverse.openfga.client.api.API;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

@ApplicationScoped
public class OpenFGAHealthCheck
implements AsyncHealthCheck {
    private final API api;

    @Inject
    public OpenFGAHealthCheck(API api) {
        this.api = api;
    }

    public Uni<HealthCheckResponse> call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"OpenFGA client connection health check");
        return this.api.health().map(response -> {
            if (response.getStatus().equalsIgnoreCase("SERVING")) {
                return builder.up().build();
            }
            return builder.down().withData("reported-status", response.getStatus()).build();
        }).onFailure().recoverWithItem(x -> builder.withData("failure", x.getMessage()).build());
    }
}

