/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.AssertionsClient;
import io.quarkiverse.openfga.client.AuthorizationModelsClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.Tuple;
import io.quarkiverse.openfga.client.model.TupleChange;
import io.quarkiverse.openfga.client.model.dto.GetStoreResponse;
import io.quarkiverse.openfga.client.model.dto.ReadChangesResponse;
import io.quarkiverse.openfga.client.model.dto.ReadTuplesBody;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.annotation.Nullable;

public class StoreClient {
    private final API api;
    private final Uni<String> storeId;

    public StoreClient(API api, Uni<String> storeId) {
        this.api = api;
        this.storeId = storeId;
    }

    public Uni<Store> get() {
        return this.storeId.flatMap(this.api::getStore).map(GetStoreResponse::asStore);
    }

    public Uni<Void> delete() {
        return this.storeId.flatMap(this.api::deleteStore);
    }

    public Uni<List<TupleChange>> changes(@Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.storeId.flatMap(storeId -> this.api.readChanges((String)storeId, type, pageSize, continuationToken)).map(ReadChangesResponse::getChanges);
    }

    public Uni<PaginatedList<Tuple>> readTuples(@Nullable Integer pageSize, @Nullable String pagingToken) {
        return this.storeId.flatMap(storeId -> this.api.readTuples((String)storeId, new ReadTuplesBody(pageSize, pagingToken))).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> readAllTuples() {
        return this.readAllTuples(null);
    }

    public Uni<List<Tuple>> readAllTuples(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::readTuples);
    }

    public AuthorizationModelsClient authorizationModels() {
        return new AuthorizationModelsClient(this.api, this.storeId);
    }

    public AssertionsClient assertions(String authorizationModelId) {
        return new AssertionsClient(this.api, this.storeId, authorizationModelId);
    }
}

