/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.Assertion;
import io.quarkiverse.openfga.client.model.dto.ReadAssertionsResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAssertionsRequest;
import io.smallrye.mutiny.Uni;
import java.util.List;

public class AssertionsClient {
    private final API api;
    private final Uni<String> storeId;
    private final String authorizationModelId;

    public AssertionsClient(API api, Uni<String> storeId, String authorizationModelId) {
        this.api = api;
        this.storeId = storeId;
        this.authorizationModelId = authorizationModelId;
    }

    public Uni<List<Assertion>> list() {
        return this.storeId.flatMap(storeId -> this.api.readAssertions((String)storeId, this.authorizationModelId)).map(ReadAssertionsResponse::getAssertions);
    }

    public Uni<Void> update(List<Assertion> assertions) {
        return this.storeId.flatMap(storeId -> this.api.writeAssertions((String)storeId, this.authorizationModelId, new WriteAssertionsRequest(assertions)));
    }
}

