/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkiverse.openfga.client.model.RelEntity;
import java.io.IOException;
import javax.annotation.Nullable;

public class RelEntitySerializer
extends StdSerializer<RelEntity>
implements ContextualSerializer {
    private static RelEntitySerializer compactInstance = null;
    private static RelEntitySerializer objectInstance = null;
    @Nullable
    private final JsonSerializer<Object> delegate;

    public RelEntitySerializer() {
        this(null);
    }

    public RelEntitySerializer(@Nullable JsonSerializer<Object> delegate) {
        super(RelEntity.class);
        this.delegate = delegate;
    }

    public void serialize(RelEntity value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.delegate != null) {
            this.delegate.serialize((Object)value, gen, provider);
        } else {
            gen.writeString(value.toString());
        }
    }

    public RelEntitySerializer createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null && format.hasShape()) {
            JsonFormat.Shape shape = format.getShape();
            switch (shape) {
                case OBJECT: {
                    return RelEntitySerializer.getObjectSerializer(prov);
                }
                case SCALAR: 
                case STRING: 
                case NATURAL: 
                case ANY: {
                    return RelEntitySerializer.getCompactSerializer(prov);
                }
            }
            prov.reportBadDefinition(this.handledType(), String.format("Unsupported serialization shape: %s", shape));
        }
        return this;
    }

    private static synchronized RelEntitySerializer getObjectSerializer(SerializerProvider prov) throws JsonMappingException {
        if (objectInstance == null) {
            BeanDescription beanDesc;
            JavaType type = TypeFactory.defaultInstance().constructType(RelEntity.class);
            JsonSerializer defaultSerializer = BeanSerializerFactory.instance.findBeanOrAddOnSerializer(prov, type, beanDesc = prov.getConfig().introspect(type), false);
            if (defaultSerializer instanceof ResolvableSerializer) {
                ResolvableSerializer resolvable = (ResolvableSerializer)defaultSerializer;
                resolvable.resolve(prov);
            }
            objectInstance = new RelEntitySerializer((JsonSerializer<Object>)defaultSerializer);
        }
        return objectInstance;
    }

    private static synchronized RelEntitySerializer getCompactSerializer(SerializerProvider prov) {
        if (compactInstance == null) {
            compactInstance = new RelEntitySerializer(null);
        }
        return compactInstance;
    }
}

