/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkiverse.openfga.client.model.RelEntity;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelUser;
import java.io.IOException;

public class RelEntityDeserializer
extends StdDeserializer<RelEntity> {
    public RelEntityDeserializer() {
        super(RelEntity.class);
    }

    public RelEntity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonToken currentToken = p.currentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            if (p.getText().contains("#")) {
                return RelUser.valueOf(p.getText());
            }
            return RelObject.valueOf(p.getText());
        }
        if (currentToken == JsonToken.START_OBJECT) {
            ObjectNode object = (ObjectNode)p.getCodec().readValue(p, ObjectNode.class);
            if (object.has("relation")) {
                return (RelEntity)ctxt.readTreeAsValue((JsonNode)object, RelUser.class);
            }
            return (RelEntity)ctxt.readTreeAsValue((JsonNode)object, RelObject.class);
        }
        return (RelEntity)ctxt.handleUnexpectedToken(RelEntity.class, p);
    }
}

