/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class WriteRequest {
    @Nullable
    private final Writes writes;
    @Nullable
    private final Deletes deletes;
    @Nullable
    private final String authorizationModelId;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    WriteRequest(@Nullable Writes writes, @Nullable Deletes deletes, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId) {
        this.writes = writes;
        this.deletes = deletes;
        this.authorizationModelId = authorizationModelId;
    }

    @Nullable
    public Writes getWrites() {
        return this.writes;
    }

    @Nullable
    public Deletes getDeletes() {
        return this.deletes;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest that = (WriteRequest)obj;
        return Objects.equals(this.writes, that.writes) && Objects.equals(this.deletes, that.deletes) && Objects.equals(this.authorizationModelId, that.authorizationModelId);
    }

    public int hashCode() {
        return Objects.hash(this.writes, this.deletes, this.authorizationModelId);
    }

    public String toString() {
        return "WriteBody[writes=" + String.valueOf(this.writes) + ", deletes=" + String.valueOf(this.deletes) + ", authorizationModelId=" + this.authorizationModelId + "]";
    }

    public static final class Builder {
        @Nullable
        private String authorizationModelId;
        @Nullable
        private Writes writes;
        @Nullable
        private Deletes deletes;

        private Builder() {
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder writes(@Nullable Writes writes) {
            this.writes = writes;
            return this;
        }

        public Builder deletes(@Nullable Deletes deletes) {
            this.deletes = deletes;
            return this;
        }

        public WriteRequest build() {
            return new WriteRequest(this.writes, this.deletes, this.authorizationModelId);
        }
    }

    public record Writes(@JsonProperty(value="tuple_keys") @JsonInclude(value=JsonInclude.Include.NON_EMPTY) Collection<? extends RelTupleKeyed> tupleKeys) {
        public Writes {
            Preconditions.parameterNonNull(tupleKeys, "tupleKeys");
        }

        public static Writes of(@Nullable Collection<? extends RelTupleKeyed> tupleKeys) {
            if (tupleKeys == null || tupleKeys.isEmpty()) {
                return new Writes(List.of());
            }
            return new Writes(tupleKeys);
        }
    }

    public record Deletes(@JsonProperty(value="tuple_keys") @JsonInclude(value=JsonInclude.Include.NON_EMPTY) Collection<? extends RelTupleKeyed> tupleKeys) {
        public Deletes {
            Preconditions.parameterNonNull(tupleKeys, "tupleKeys");
        }

        public static Deletes of(@Nullable Collection<? extends RelTupleKeyed> tupleKeys) {
            if (tupleKeys == null || tupleKeys.isEmpty()) {
                return new Deletes(List.of());
            }
            return new Deletes(tupleKeys);
        }
    }
}

