/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Schema;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public final class WriteAuthorizationModelRequest {
    private final Collection<Schema.TypeDefinition> typeDefinitions;
    private final String schemaVersion;
    @Nullable
    private final Map<String, Schema.Condition> conditions;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    WriteAuthorizationModelRequest(@JsonProperty(value="type_definitions") Collection<Schema.TypeDefinition> typeDefinitions, String schemaVersion, @Nullable Map<String, Schema.Condition> conditions) {
        this.typeDefinitions = typeDefinitions;
        this.schemaVersion = schemaVersion;
        this.conditions = conditions;
    }

    @JsonProperty(value="type_definitions")
    public Collection<Schema.TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Nullable
    public Map<String, Schema.Condition> getConditions() {
        return this.conditions;
    }

    public static final class Builder {
        @Nullable
        private Collection<Schema.TypeDefinition> typeDefinitions;
        @Nullable
        private String schemaVersion;
        @Nullable
        private Map<String, Schema.Condition> conditions;

        private Builder() {
        }

        public Builder typeDefinitions(Collection<Schema.TypeDefinition> typeDefinitions) {
            this.typeDefinitions = typeDefinitions;
            return this;
        }

        public Builder schemaVersion(@Nullable String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder conditions(@Nullable Map<String, Schema.Condition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public WriteAuthorizationModelRequest build() {
            return new WriteAuthorizationModelRequest(Preconditions.parameterNonNull(this.typeDefinitions, "typeDefinitions"), Preconditions.parameterNonBlank(this.schemaVersion, "schemaVersion"), this.conditions);
        }
    }
}

