/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Assertion;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class WriteAssertionsRequest {
    private final String authorizationModelId;
    private final List<Assertion> assertions;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    WriteAssertionsRequest(@JsonProperty(value="authorization_model_id") String authorizationModelId, List<Assertion> assertions) {
        this.authorizationModelId = authorizationModelId;
        this.assertions = assertions;
    }

    @JsonProperty(value="authorization_model_id")
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof WriteAssertionsRequest)) {
            return false;
        }
        WriteAssertionsRequest that = (WriteAssertionsRequest)obj;
        return Objects.equals(this.assertions, that.assertions) && Objects.equals(this.authorizationModelId, that.authorizationModelId);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.authorizationModelId);
    }

    public String toString() {
        return "WriteAssertionsRequest[assertions=" + String.valueOf(this.assertions) + ", authorizationModelId=" + this.authorizationModelId + "]";
    }

    public static final class Builder {
        @Nullable
        private String authorizationModelId;
        @Nullable
        private List<Assertion> assertions;

        private Builder() {
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder assertions(List<Assertion> assertions) {
            this.assertions = assertions;
            return this;
        }

        public WriteAssertionsRequest build() {
            return new WriteAssertionsRequest(Preconditions.parameterNonBlank(this.authorizationModelId, "authorizationModelId"), Preconditions.parameterNonNull(this.assertions, "assertions"));
        }
    }
}

