/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelObjectType;
import io.quarkiverse.openfga.client.model.RelTyped;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReadRequest {
    @Nullable
    private final TupleKeyFilter tupleKey;
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final String continuationToken;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ReadRequest(@JsonProperty(value="tuple_key") @Nullable TupleKeyFilter tupleKey, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @JsonProperty(value="page_size") @Nullable Integer pageSize, @JsonProperty(value="continuation_token") @Nullable String continuationToken) {
        this.tupleKey = tupleKey;
        this.authorizationModelId = authorizationModelId;
        this.pageSize = pageSize;
        this.continuationToken = continuationToken;
    }

    @JsonProperty(value="tuple_key")
    @Nullable
    public TupleKeyFilter getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="page_size")
    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="continuation_token")
    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ReadRequest)) {
            return false;
        }
        ReadRequest that = (ReadRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.continuationToken, that.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.authorizationModelId, this.pageSize, this.continuationToken);
    }

    public String toString() {
        return "ReadRequest[tupleKey=" + String.valueOf(this.tupleKey) + ", authorizationModelId=" + this.authorizationModelId + ", pageSize=" + this.pageSize + ", continuationToken=" + this.continuationToken + "]";
    }

    public static final class Builder {
        @Nullable
        private TupleKeyFilter tupleKey;
        @Nullable
        private String authorizationModelId;
        @Nullable
        private Integer pageSize;
        @Nullable
        private String continuationToken;

        private Builder() {
        }

        public Builder tupleKey(@Nullable TupleKeyFilter tupleKey) {
            if (tupleKey != null && tupleKey.object == null && tupleKey.relation == null && tupleKey.user == null) {
                tupleKey = null;
            }
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public ReadRequest build() {
            return new ReadRequest(this.tupleKey, this.authorizationModelId, this.pageSize, this.continuationToken);
        }
    }

    public static final class TupleKeyFilter {
        @Nullable
        private final RelObject object;
        @Nullable
        private final String relation;
        @Nullable
        private final RelUser user;

        public static Builder builder() {
            return new Builder();
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        TupleKeyFilter(@JsonProperty(value="object") @Nullable RelObject object, @JsonProperty(value="relation") @Nullable String relation, @JsonProperty(value="user") @Nullable RelUser user) {
            this.object = object;
            this.relation = relation;
            this.user = user;
        }

        @Nullable
        public RelObject getObject() {
            return this.object;
        }

        @Nullable
        public String getRelation() {
            return this.relation;
        }

        @Nullable
        public RelUser getUser() {
            return this.user;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TupleKeyFilter)) {
                return false;
            }
            TupleKeyFilter that = (TupleKeyFilter)obj;
            return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.user, that.user);
        }

        public int hashCode() {
            return Objects.hash(this.object, this.relation, this.user);
        }

        public String toString() {
            return "PartialTupleKey[object=" + String.valueOf(this.object) + ", relation=" + this.relation + ", user=" + String.valueOf(this.user) + "]";
        }

        public static final class Builder {
            @Nullable
            private RelTyped typeOrObject;
            @Nullable
            private String relation;
            @Nullable
            private RelUser user;

            private Builder() {
            }

            public Builder typeOrObject(@Nullable RelTyped typeOrObject) {
                this.typeOrObject = typeOrObject;
                return this;
            }

            public Builder relation(@Nullable String relation) {
                this.relation = relation;
                return this;
            }

            public Builder user(@Nullable RelUser user) {
                this.user = user;
                return this;
            }

            public TupleKeyFilter build() {
                RelTyped relTyped = this.typeOrObject;
                if (relTyped instanceof RelObjectType) {
                    RelObjectType type = (RelObjectType)relTyped;
                    RelObject typeObject = RelObject.typeOnly(type.getType());
                    RelUser user = Preconditions.parameterNonNull(this.user, "user", ignore -> "User must be specified when object is a type only");
                    return new TupleKeyFilter(typeObject, this.relation, user);
                }
                relTyped = this.typeOrObject;
                if (relTyped instanceof RelObject) {
                    RelObject object = (RelObject)relTyped;
                    return new TupleKeyFilter(object, this.relation, this.user);
                }
                if (this.typeOrObject == null) {
                    return new TupleKeyFilter(null, this.relation, this.user);
                }
                throw new IllegalArgumentException("typeOrObject is invalid: " + String.valueOf(this.typeOrObject));
            }
        }
    }
}

