/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReadChangesRequest {
    @Nullable
    private final String type;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final String continuationToken;
    @Nullable
    private final OffsetDateTime startTime;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ReadChangesRequest(@Nullable String type, @JsonProperty(value="page_size") @Nullable Integer pageSize, @JsonProperty(value="continuation_token") @Nullable String continuationToken, @JsonProperty(value="start_time") @Nullable OffsetDateTime startTime) {
        this.type = type;
        this.pageSize = pageSize;
        this.continuationToken = continuationToken;
        this.startTime = startTime;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="page_size")
    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="continuation_token")
    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="start_time")
    @Nullable
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ReadChangesRequest)) {
            return false;
        }
        ReadChangesRequest that = (ReadChangesRequest)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.continuationToken, that.continuationToken) && Objects.equals(this.startTime, that.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pageSize, this.continuationToken, this.startTime);
    }

    public String toString() {
        return "ReadChangesRequest[type=" + this.type + ", pageSize=" + this.pageSize + ", continuationToken=" + this.continuationToken + ", startTime=" + String.valueOf(this.startTime) + "]";
    }

    public static final class Builder {
        @Nullable
        private String type;
        @Nullable
        private Integer pageSize;
        @Nullable
        private String continuationToken;
        @Nullable
        private OffsetDateTime startTime;

        private Builder() {
        }

        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Builder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder startTime(@Nullable OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public ReadChangesRequest build() {
            return new ReadChangesRequest(this.type, this.pageSize, this.continuationToken, this.startTime);
        }
    }
}

