/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ListUsersRequest {
    @Nullable
    private final String authorizationModelId;
    private final RelObject object;
    private final String relation;
    private final Collection<UserTypeFilter> userFilters;
    @Nullable
    private final Collection<? extends RelTupleKeyed> contextualTuples;
    @Nullable
    private final Map<String, Object> context;
    @Nullable
    private final ConsistencyPreference consistency;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ListUsersRequest(@JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, RelObject object, String relation, @JsonProperty(value="user_filters") Collection<UserTypeFilter> userFilters, @JsonProperty(value="contextual_tuples") @Nullable Collection<? extends RelTupleKeyed> contextualTuples, @Nullable Map<String, Object> context, @Nullable ConsistencyPreference consistency) {
        this.authorizationModelId = authorizationModelId;
        this.object = object;
        this.relation = relation;
        this.userFilters = userFilters;
        this.contextualTuples = contextualTuples;
        this.context = context;
        this.consistency = consistency;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonFormat(shape=JsonFormat.Shape.OBJECT)
    public RelObject getObject() {
        return this.object;
    }

    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="user_filters")
    public Collection<UserTypeFilter> getUserFilters() {
        return this.userFilters;
    }

    @JsonProperty(value="contextual_tuples")
    @Nullable
    public Collection<? extends RelTupleKeyed> getContextualTuples() {
        return this.contextualTuples;
    }

    @Nullable
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest that = (ListUsersRequest)obj;
        return Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.userFilters, that.userFilters) && Objects.equals(this.contextualTuples, that.contextualTuples) && Objects.equals(this.context, that.context) && Objects.equals((Object)this.consistency, (Object)that.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationModelId, this.object, this.relation, this.userFilters, this.contextualTuples, this.context, this.consistency});
    }

    public String toString() {
        return "ListObjectsRequest[authorizationModelId=" + this.authorizationModelId + ", object=" + String.valueOf(this.object) + ", relation=" + this.relation + ", userFilters=" + String.valueOf(this.userFilters) + ", contextualTupleKeys=" + String.valueOf(this.contextualTuples) + ", context=" + String.valueOf(this.context) + ", consistency=" + String.valueOf((Object)this.consistency) + "]";
    }

    public static final class Builder {
        @Nullable
        private String authorizationModelId;
        @Nullable
        private RelObject object;
        @Nullable
        private String relation;
        @Nullable
        private Collection<UserTypeFilter> userFilters;
        @Nullable
        private Collection<? extends RelTupleKeyed> contextualTuples;
        @Nullable
        private Map<String, Object> context;
        @Nullable
        private ConsistencyPreference consistency;

        private Builder() {
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder object(RelObject object) {
            this.object = object;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public Builder userFilters(Collection<UserTypeFilter> userFilters) {
            this.userFilters = userFilters;
            return this;
        }

        public Builder contextualTuples(@Nullable Collection<? extends RelTupleKeyed> contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Builder context(@Nullable Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public ListUsersRequest build() {
            return new ListUsersRequest(this.authorizationModelId, Preconditions.parameterNonNull(this.object, "object"), Preconditions.parameterNonNull(this.relation, "relation"), Preconditions.parameterNonNull(this.userFilters, "userFilters"), this.contextualTuples, this.context, this.consistency);
        }
    }

    public static final class UserTypeFilter {
        private final String type;
        @Nullable
        private final String relation;

        public static Builder builder() {
            return new Builder();
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        UserTypeFilter(String type, @Nullable String relation) {
            this.type = type;
            this.relation = relation;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getRelation() {
            return this.relation;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof UserTypeFilter)) {
                return false;
            }
            UserTypeFilter that = (UserTypeFilter)obj;
            return this.type.equals(that.type) && Objects.equals(this.relation, that.relation);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.relation);
        }

        public String toString() {
            return "UserTypeFilter[type='" + this.type + "', relation='" + this.relation + "]";
        }

        public static final class Builder {
            @Nullable
            private String type;
            @Nullable
            private String relation;

            private Builder() {
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder relation(@Nullable String relation) {
                this.relation = relation;
                return this;
            }

            public UserTypeFilter build() {
                return new UserTypeFilter(Preconditions.parameterNonBlank(this.type, "type"), this.relation);
            }
        }
    }
}

