/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ListStoresRequest {
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final String continuationToken;
    @Nullable
    private final String name;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ListStoresRequest(@JsonProperty(value="page_size") @Nullable Integer pageSize, @JsonProperty(value="continuation_token") @Nullable String continuationToken, @JsonProperty(value="name") @Nullable String name) {
        this.pageSize = pageSize;
        this.continuationToken = continuationToken;
        this.name = name;
    }

    @JsonProperty(value="page_size")
    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="continuation_token")
    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ListStoresRequest)) {
            return false;
        }
        ListStoresRequest that = (ListStoresRequest)obj;
        return Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.continuationToken, that.continuationToken) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.pageSize, this.continuationToken, this.name);
    }

    public String toString() {
        return "ListStoresRequest[pageSize=" + this.pageSize + ", continuationToken=" + this.continuationToken + ", name=" + this.name + "]";
    }

    public static final class Builder {
        @Nullable
        private Integer pageSize;
        @Nullable
        private String continuationToken;
        @Nullable
        private String name;

        private Builder() {
        }

        public Builder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public ListStoresRequest build() {
            return new ListStoresRequest(this.pageSize, this.continuationToken, this.name);
        }
    }
}

