/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.RelPartialTupleKeyed;
import io.quarkiverse.openfga.client.model.RelTupleKeys;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ExpandRequest {
    private final RelPartialTupleKeyed tupleKey;
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final RelTupleKeys contextualTuples;
    @Nullable
    private final Map<String, Object> context;
    @Nullable
    private final ConsistencyPreference consistency;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ExpandRequest(@JsonProperty(value="tuple_key") RelPartialTupleKeyed tupleKey, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @JsonProperty(value="contextual_tuples") @Nullable RelTupleKeys contextualTuples, @JsonProperty(value="context") @Nullable Map<String, Object> context, @Nullable ConsistencyPreference consistency) {
        this.tupleKey = tupleKey;
        this.authorizationModelId = authorizationModelId;
        this.contextualTuples = contextualTuples;
        this.context = context;
        this.consistency = consistency;
    }

    @JsonProperty(value="tuple_key")
    @JsonSerialize(typing=JsonSerialize.Typing.STATIC)
    public RelPartialTupleKeyed getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @Nullable
    public RelTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @Nullable
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ExpandRequest)) {
            return false;
        }
        ExpandRequest that = (ExpandRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)that.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.authorizationModelId, this.consistency});
    }

    public String toString() {
        return "ExpandRequest[tupleKey=" + String.valueOf(this.tupleKey) + ", authorizationModelId=" + this.authorizationModelId + ", consistency=" + String.valueOf((Object)this.consistency) + "]";
    }

    public static final class Builder {
        @Nullable
        private RelPartialTupleKeyed tupleKey;
        @Nullable
        private String authorizationModelId;
        @Nullable
        private RelTupleKeys contextualTuples;
        @Nullable
        private Map<String, Object> context;
        @Nullable
        private ConsistencyPreference consistency;

        private Builder() {
        }

        public Builder tupleKey(RelPartialTupleKeyed tupleKey) {
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder contextualTuples(@Nullable RelTupleKeys contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Builder context(@Nullable Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public ExpandRequest build() {
            return new ExpandRequest(Preconditions.parameterNonNull(this.tupleKey, "tupleKey"), this.authorizationModelId, this.contextualTuples, this.context, this.consistency);
        }
    }
}

