/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.RelTupleKeys;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CheckRequest {
    private final RelTupleKeyed tupleKey;
    @Nullable
    private final RelTupleKeys contextualTuples;
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final Boolean trace;
    @Nullable
    private final Map<String, Object> context;
    @Nullable
    private final ConsistencyPreference consistency;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    CheckRequest(@JsonProperty(value="tuple_key") RelTupleKeyed tupleKey, @JsonProperty(value="contextual_tuples") @Nullable RelTupleKeys contextualTuples, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @Nullable Boolean trace, @Nullable Map<String, Object> context, @Nullable ConsistencyPreference consistency) {
        this.tupleKey = tupleKey;
        this.contextualTuples = contextualTuples;
        this.authorizationModelId = authorizationModelId;
        this.trace = trace;
        this.context = context;
        this.consistency = consistency;
    }

    @JsonProperty(value="tuple_key")
    @JsonSerialize(typing=JsonSerialize.Typing.STATIC)
    public RelTupleKeyed getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="contextual_tuples")
    @Nullable
    public RelTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @Nullable
    public Boolean getTrace() {
        return this.trace;
    }

    @Nullable
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CheckRequest)) {
            return false;
        }
        CheckRequest that = (CheckRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.contextualTuples, that.contextualTuples) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.trace, that.trace) && Objects.equals(this.context, that.context) && this.consistency == that.consistency;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.contextualTuples, this.authorizationModelId, this.trace, this.context, this.consistency});
    }

    public String toString() {
        return "CheckRequest[tupleKey=" + String.valueOf(this.tupleKey) + ", contextualTupleKeys=" + String.valueOf(this.contextualTuples) + ", authorizationModelId=" + this.authorizationModelId + ", trace=" + this.trace + ", context=" + String.valueOf(this.context) + ", consistency=" + String.valueOf((Object)this.consistency) + "]";
    }

    public static final class Builder {
        @Nullable
        private RelTupleKeyed tupleKey;
        @Nullable
        private RelTupleKeys contextualTuples;
        @Nullable
        private String authorizationModelId;
        @Nullable
        private Boolean trace;
        @Nullable
        private Map<String, Object> context;
        @Nullable
        private ConsistencyPreference consistency;

        private Builder() {
        }

        public Builder tupleKey(RelTupleKeyed tupleKey) {
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder contextualTuples(@Nullable RelTupleKeys contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder trace(@Nullable Boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder context(@Nullable Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public CheckRequest build() {
            return new CheckRequest(Preconditions.parameterNonNull(this.tupleKey, "tupleKey"), this.contextualTuples, this.authorizationModelId, this.trace, this.context, this.consistency);
        }
    }
}

