/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Check;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BatchCheckRequest {
    private final Collection<Check> checks;
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final ConsistencyPreference consistency;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    BatchCheckRequest(Collection<Check> checks, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @Nullable ConsistencyPreference consistency) {
        this.checks = checks;
        this.authorizationModelId = authorizationModelId;
        this.consistency = consistency;
    }

    public Collection<Check> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof BatchCheckRequest)) {
            return false;
        }
        BatchCheckRequest that = (BatchCheckRequest)obj;
        return Objects.equals(this.checks, that.checks) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && this.consistency == that.consistency;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checks, this.authorizationModelId, this.consistency});
    }

    public String toString() {
        return "BatchCheckRequest[checks=" + String.valueOf(this.checks) + ", authorizationModelId=" + this.authorizationModelId + ", consistency=" + String.valueOf((Object)this.consistency) + "]";
    }

    public static final class Builder {
        @Nullable
        private Collection<Check> checks;
        @Nullable
        private String authorizationModelId;
        @Nullable
        private ConsistencyPreference consistency;

        private Builder() {
        }

        public Builder checks(Collection<Check> checks) {
            this.checks = checks;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public BatchCheckRequest build() {
            return new BatchCheckRequest(Preconditions.parameterNonNull(this.checks, "checks"), this.authorizationModelId, this.consistency);
        }
    }
}

