/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Store {
    private final String id;
    private final String name;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    @Nullable
    private final OffsetDateTime deletedAt;

    public static Store of(String id, String name, OffsetDateTime createdAt, OffsetDateTime updatedAt, @Nullable OffsetDateTime deletedAt) {
        return new Store(id, name, createdAt, updatedAt, deletedAt);
    }

    public static Store of(String id, String name, OffsetDateTime createdAt, OffsetDateTime updatedAt) {
        return Store.of(id, name, createdAt, updatedAt, null);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Store(String id, String name, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="updated_at") OffsetDateTime updatedAt, @JsonProperty(value="deleted_at") @Nullable OffsetDateTime deletedAt) {
        this.id = Preconditions.parameterNonNull(id, "id");
        this.name = Preconditions.parameterNonNull(name, "name");
        this.createdAt = Preconditions.parameterNonNull(createdAt, "createdAt");
        this.updatedAt = Preconditions.parameterNonNull(updatedAt, "updatedAt");
        this.deletedAt = deletedAt;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="deleted_at")
    @Nullable
    public OffsetDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Store)) {
            return false;
        }
        Store that = (Store)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.deletedAt, that.deletedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt, this.deletedAt);
    }

    public String toString() {
        return "Store[id=" + this.id + ", name=" + this.name + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", deletedAt=" + String.valueOf(this.deletedAt) + "]";
    }
}

