/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelObjectType;
import io.quarkiverse.openfga.client.model.RelTyped;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import io.quarkiverse.openfga.client.model.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Schema {
    public static TypeDefinition typeDefinition(String type) {
        return TypeDefinition.builder().type(type).build();
    }

    public static TypeDefinition.Builder typeDefinition() {
        return TypeDefinition.builder();
    }

    public static TypeDefinition.Metadata.Builder typeMetadata() {
        return TypeDefinition.Metadata.builder();
    }

    public static TypeDefinition.Metadata.Relation.Builder typeMetadataRelation() {
        return TypeDefinition.Metadata.Relation.builder();
    }

    public static TypeDefinition.Metadata.Relation.Reference.Builder typeMetadataRelationReference() {
        return TypeDefinition.Metadata.Relation.Reference.builder();
    }

    public static Condition.Builder condition() {
        return Condition.builder();
    }

    public static Condition.Parameter.Builder conditionParameter() {
        return Condition.Parameter.builder();
    }

    public static Condition.Metadata.Builder conditionMetadata() {
        return Condition.Metadata.builder();
    }

    public static Object object(String type, String id) {
        return new Object(type, id);
    }

    public static TypedWildcard wildcard(String type) {
        return new TypedWildcard(type);
    }

    public static UsersetUser usersetUser(String type, String id, String relation) {
        return new UsersetUser(type, id, relation);
    }

    public static User user(Object object) {
        return new User(object, null, null);
    }

    public static User user(String type, String id) {
        return new User(Schema.object(type, id), null, null);
    }

    public static User user(UsersetUser userset) {
        return new User(null, userset, null);
    }

    public static User user(String type, String id, String relation) {
        return Schema.user(new UsersetUser(type, id, relation));
    }

    public static User user(TypedWildcard wildcard) {
        return new User(null, null, wildcard);
    }

    public static User user(String type) {
        return new User(null, null, new TypedWildcard(type));
    }

    public static Userset thisUserset() {
        return new Userset(DirectUserset.instance(), null, null, null, null, null);
    }

    public static Userset computedUserset(String object, String relation) {
        return new Userset(null, Schema.objectRelation(object, relation), null, null, null, null);
    }

    public static Userset unionUserset(Collection<Userset> child) {
        return new Userset(null, null, null, new Usersets(child), null, null);
    }

    public static Userset intersectionUserset(Collection<Userset> child) {
        return new Userset(null, null, null, null, new Usersets(child), null);
    }

    public static Userset tupleToUserset(ObjectRelation tupleset, ObjectRelation computedUserset) {
        return new Userset(null, null, new V1.TupleToUserset(tupleset, computedUserset), null, null, null);
    }

    public static Userset differenceUserset(Userset base, Userset subtract) {
        return new Userset(null, null, null, null, null, new V1.Difference(base, subtract));
    }

    public static Usersets usersets(Collection<Userset> child) {
        return new Usersets(child);
    }

    public static ObjectRelation objectRelation(String object, String relation) {
        return new ObjectRelation(object, relation);
    }

    public static UsersetTree usersetTree(UsersetTree.Node root) {
        return new UsersetTree(root);
    }

    public static UsersetTree.Node usersetTreeNode(String name, UsersetTree.Leaf leaf) {
        return new UsersetTree.Node(name, leaf, null, null, null);
    }

    public static UsersetTree.Node usersetTreeNode(String name, UsersetTree.Difference difference) {
        return new UsersetTree.Node(name, null, difference, null, null);
    }

    public static UsersetTree.Node usersetTreeNodeUnion(String name, UsersetTree.Nodes union) {
        return new UsersetTree.Node(name, null, null, union, null);
    }

    public static UsersetTree.Node usersetTreeNodeIntersection(String name, UsersetTree.Nodes intersection) {
        return new UsersetTree.Node(name, null, null, null, intersection);
    }

    public static UsersetTree.Leaf usersetTreeLeaf(Users users) {
        return new UsersetTree.Leaf(users, null, null);
    }

    public static UsersetTree.Leaf usersetTreeLeaf(Collection<String> users) {
        return new UsersetTree.Leaf(new Users(users), null, null);
    }

    public static UsersetTree.Leaf usersetTreeLeaf(String computedUserset) {
        return new UsersetTree.Leaf(null, new UsersetTree.Computed(computedUserset), null);
    }

    public static UsersetTree.Leaf usersetTreeLeaf(String tupleset, Collection<UsersetTree.Computed> computed) {
        return new UsersetTree.Leaf(null, null, new UsersetTree.TupleToUserset(tupleset, computed));
    }

    public static UsersetTree.Node usersetTreeLeafNode(String name, Collection<String> users) {
        return Schema.usersetTreeNode(name, Schema.usersetTreeLeaf(users));
    }

    public static UsersetTree.Node usersetTreeLeafNode(String name, String computedUserset) {
        return Schema.usersetTreeNode(name, Schema.usersetTreeLeaf(computedUserset));
    }

    public static UsersetTree.Node usersetTreeLeafNode(String name, String tupleset, Collection<UsersetTree.Computed> computed) {
        return Schema.usersetTreeNode(name, Schema.usersetTreeLeaf(tupleset, computed));
    }

    public static UsersetTree.Difference usersetTreeDifference(UsersetTree.Node base, UsersetTree.Node subtract) {
        return new UsersetTree.Difference(base, subtract);
    }

    public static UsersetTree.Nodes usersetTreeNodes(Collection<? extends UsersetTree.Node> nodes) {
        return new UsersetTree.Nodes(nodes);
    }

    public static UsersetTree.Node usersetTreeDifferenceNode(String name, UsersetTree.Node base, UsersetTree.Node subtract) {
        return Schema.usersetTreeNode(name, Schema.usersetTreeDifference(base, subtract));
    }

    public static UsersetTree.Node usersetTreeUnionNode(String name, Collection<? extends UsersetTree.Node> nodes) {
        return Schema.usersetTreeNodeUnion(name, new UsersetTree.Nodes(nodes));
    }

    public static UsersetTree.Node usersetTreeIntersectionNode(String name, Collection<? extends UsersetTree.Node> nodes) {
        return Schema.usersetTreeNodeIntersection(name, new UsersetTree.Nodes(nodes));
    }

    public static final class TypeDefinition {
        private final String type;
        private final Map<String, Userset> relations;
        @Nullable
        private final Metadata metadata;

        public static Builder builder() {
            return new Builder();
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        TypeDefinition(String type, @Nullable Map<String, Userset> relations, @Nullable Metadata metadata) {
            this.type = Preconditions.parameterNonNull(type, "type");
            this.relations = Optional.ofNullable(relations).orElseGet(HashMap::new);
            this.metadata = metadata;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Userset> getRelations() {
            return this.relations;
        }

        @Nullable
        public Metadata getMetadata() {
            return this.metadata;
        }

        public boolean equals(@Nullable java.lang.Object obj) {
            if (!(obj instanceof TypeDefinition)) {
                return false;
            }
            TypeDefinition that = (TypeDefinition)obj;
            return Objects.equals(this.type, that.type) && Objects.equals(this.relations, that.relations) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.relations, this.metadata);
        }

        public String toString() {
            return "TypeDefinition[type=" + this.type + ", relations=" + String.valueOf(this.relations) + ", metadata=" + String.valueOf(this.metadata) + "]";
        }

        public static final class Builder {
            private String type;
            @Nullable
            private Map<String, Userset> relations;
            @Nullable
            private Metadata metadata;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder relations(@Nullable Map<String, Userset> relations) {
                if (relations == null) {
                    this.relations = null;
                    return this;
                }
                return this.addRelations(relations);
            }

            public Builder addRelations(@Nullable Map<String, Userset> relations) {
                if (relations == null) {
                    return this;
                }
                if (this.relations == null) {
                    this.relations = new HashMap<String, Userset>();
                }
                this.relations.putAll(relations);
                return this;
            }

            public Builder addRelation(String relation, Userset userset) {
                if (this.relations == null) {
                    this.relations = new HashMap<String, Userset>();
                }
                this.relations.put(relation, userset);
                return this;
            }

            public Builder metadata(@Nullable Metadata metadata) {
                this.metadata = metadata;
                return this;
            }

            public TypeDefinition build() {
                return new TypeDefinition(this.type, this.relations, this.metadata);
            }
        }

        public static final class Metadata {
            @Nullable
            private final Map<String, Relation> relations;
            @Nullable
            private final String module;
            @JsonProperty(value="source_info")
            @Nullable
            private final String sourceInfo;

            public static Builder builder() {
                return new Builder();
            }

            @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
            Metadata(@Nullable Map<String, Relation> relations, @Nullable String module, @Nullable String sourceInfo) {
                this.relations = relations;
                this.module = Strings.emptyToNull(module);
                this.sourceInfo = Strings.emptyToNull(sourceInfo);
            }

            @Nullable
            public Map<String, Relation> getRelations() {
                return this.relations;
            }

            @Nullable
            public String getModule() {
                return this.module;
            }

            @JsonProperty(value="source_info")
            @Nullable
            public String getSourceInfo() {
                return this.sourceInfo;
            }

            public boolean equals(java.lang.Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Metadata)) {
                    return false;
                }
                Metadata metadata = (Metadata)o;
                return Objects.equals(this.relations, metadata.relations) && Objects.equals(this.module, metadata.module) && Objects.equals(this.sourceInfo, metadata.sourceInfo);
            }

            public int hashCode() {
                return Objects.hash(this.relations, this.module, this.sourceInfo);
            }

            public String toString() {
                return "Metadata{relations=" + String.valueOf(this.relations) + ", module=" + this.module + ", sourceInfo=" + this.sourceInfo + "}";
            }

            public static final class Builder {
                @Nullable
                private Map<String, Relation> relations;
                @Nullable
                private String module;
                @Nullable
                private String sourceInfo;

                private Builder() {
                }

                public Builder relations(@Nullable Map<String, Relation> relations) {
                    this.relations = relations;
                    return this;
                }

                public Builder addRelations(@Nullable Map<String, Relation> relations) {
                    if (relations == null) {
                        return this;
                    }
                    if (this.relations == null) {
                        this.relations = new HashMap<String, Relation>();
                    }
                    for (Map.Entry<String, Relation> entry : relations.entrySet()) {
                        if (this.relations.containsKey(entry.getKey())) {
                            throw new IllegalArgumentException("Duplicate key: " + entry.getKey());
                        }
                        this.relations.put(entry.getKey(), entry.getValue());
                    }
                    return this;
                }

                public Builder addRelation(String key, Relation value) {
                    if (this.relations == null) {
                        this.relations = new HashMap<String, Relation>();
                    }
                    if (this.relations.containsKey(key)) {
                        throw new IllegalArgumentException("Duplicate key: " + key);
                    }
                    this.relations.put(key, value);
                    return this;
                }

                public Builder module(@Nullable String module) {
                    this.module = module;
                    return this;
                }

                public Builder sourceInfo(@Nullable String sourceInfo) {
                    this.sourceInfo = sourceInfo;
                    return this;
                }

                public Metadata build() {
                    return new Metadata(this.relations, this.module, this.sourceInfo);
                }
            }

            public static final class Relation {
                @Nullable
                private final List<Reference> directlyRelatedUserTypes;
                @Nullable
                private final String module;
                @JsonProperty(value="source_info")
                @Nullable
                private final String sourceInfo;

                public static Builder builder() {
                    return new Builder();
                }

                @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
                Relation(@JsonProperty(value="directly_related_user_types") @Nullable List<Reference> directlyRelatedUserTypes, @Nullable String module, @JsonProperty(value="source_info") @Nullable String sourceInfo) {
                    this.directlyRelatedUserTypes = directlyRelatedUserTypes;
                    this.module = Strings.emptyToNull(module);
                    this.sourceInfo = Strings.emptyToNull(sourceInfo);
                }

                @JsonProperty(value="directly_related_user_types")
                @Nullable
                public List<Reference> getDirectlyRelatedUserTypes() {
                    return this.directlyRelatedUserTypes;
                }

                @Nullable
                public String getModule() {
                    return this.module;
                }

                @JsonProperty(value="source_info")
                @Nullable
                public String getSourceInfo() {
                    return this.sourceInfo;
                }

                public boolean equals(java.lang.Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (!(o instanceof Relation)) {
                        return false;
                    }
                    Relation that = (Relation)o;
                    return Objects.equals(this.directlyRelatedUserTypes, that.directlyRelatedUserTypes) && Objects.equals(this.module, that.module) && Objects.equals(this.sourceInfo, that.sourceInfo);
                }

                public int hashCode() {
                    return Objects.hash(this.directlyRelatedUserTypes, this.module, this.sourceInfo);
                }

                public String toString() {
                    return "RelationMetadata[directlyRelatedUserTypes=" + String.valueOf(this.directlyRelatedUserTypes) + ", module=" + this.module + ", sourceInfo=" + this.sourceInfo + "]";
                }

                public static final class Builder {
                    @Nullable
                    private List<Reference> directlyRelatedUserTypes;
                    @Nullable
                    private String module;
                    @Nullable
                    private String sourceInfo;

                    private Builder() {
                    }

                    public Builder directlyRelatedUserTypes(@Nullable Collection<Reference> directlyRelatedUserTypes) {
                        if (directlyRelatedUserTypes == null) {
                            return this;
                        }
                        this.directlyRelatedUserTypes = new ArrayList<Reference>(directlyRelatedUserTypes);
                        return this;
                    }

                    public Builder addDirectlyRelatedUserTypes(@Nullable Collection<Reference> directlyRelatedUserTypes) {
                        if (directlyRelatedUserTypes == null) {
                            return this;
                        }
                        if (this.directlyRelatedUserTypes == null) {
                            this.directlyRelatedUserTypes = new ArrayList<Reference>();
                        }
                        this.directlyRelatedUserTypes.addAll(directlyRelatedUserTypes);
                        return this;
                    }

                    public Builder addDirectlyRelatedUserTypes(Reference ... directlyRelatedUserTypes) {
                        return this.addDirectlyRelatedUserTypes(List.of(directlyRelatedUserTypes));
                    }

                    public Builder module(@Nullable String module) {
                        this.module = module;
                        return this;
                    }

                    public Builder sourceInfo(@Nullable String sourceInfo) {
                        this.sourceInfo = sourceInfo;
                        return this;
                    }

                    public Relation build() {
                        return new Relation(this.directlyRelatedUserTypes, this.module, this.sourceInfo);
                    }
                }

                public static final class Reference {
                    private final String type;
                    @Nullable
                    private final String relation;
                    @Nullable
                    private final java.lang.Object wildcard;
                    @Nullable
                    private final String condition;

                    public static Builder builder() {
                        return new Builder();
                    }

                    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
                    Reference(String type, @Nullable String relation, @Nullable java.lang.Object wildcard, @Nullable String condition) {
                        this.type = Preconditions.parameterNonBlank(type, "type");
                        this.relation = Strings.emptyToNull(relation);
                        this.wildcard = wildcard;
                        this.condition = Strings.emptyToNull(condition);
                    }

                    public String getType() {
                        return this.type;
                    }

                    @Nullable
                    public String getRelation() {
                        return this.relation;
                    }

                    @Nullable
                    public java.lang.Object getWildcard() {
                        return this.wildcard;
                    }

                    @Nullable
                    public String getCondition() {
                        return this.condition;
                    }

                    public boolean equals(java.lang.Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (!(o instanceof Reference)) {
                            return false;
                        }
                        Reference that = (Reference)o;
                        return Objects.equals(this.type, that.type) && Objects.equals(this.relation, that.relation) && Objects.equals(this.wildcard, that.wildcard) && Objects.equals(this.condition, that.condition);
                    }

                    public int hashCode() {
                        return Objects.hash(this.type, this.relation, this.wildcard, this.condition);
                    }

                    public String toString() {
                        return "RelationReference[type=" + this.type + ", relation=" + this.relation + ", wildcard=" + String.valueOf(this.wildcard) + ", condition=" + this.condition + "]";
                    }

                    public static final class Builder {
                        private String type;
                        @Nullable
                        private String relation;
                        @Nullable
                        private java.lang.Object wildcard;
                        @Nullable
                        private String condition;

                        private Builder() {
                        }

                        public Builder type(String type) {
                            this.type = type;
                            return this;
                        }

                        public Builder relation(@Nullable String relation) {
                            this.relation = relation;
                            return this;
                        }

                        public Builder wildcard(@Nullable java.lang.Object wildcard) {
                            this.wildcard = wildcard;
                            return this;
                        }

                        public Builder condition(@Nullable String condition) {
                            this.condition = condition;
                            return this;
                        }

                        public Reference build() {
                            return new Reference(this.type, this.relation, this.wildcard, this.condition);
                        }
                    }
                }
            }
        }
    }

    public static final class Condition {
        private final String name;
        private final String expression;
        @Nullable
        private final Map<String, Parameter> parameters;
        @Nullable
        private final Metadata metadata;

        public static Builder builder() {
            return new Builder();
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        Condition(String name, String expression, @Nullable Map<String, Parameter> parameters, @Nullable Metadata metadata) {
            this.name = Preconditions.parameterNonBlank(name, "name");
            this.expression = Preconditions.parameterNonBlank(expression, "expression");
            this.parameters = Optional.ofNullable(parameters).map(HashMap::new).orElseGet(HashMap::new);
            this.metadata = metadata;
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        @Nullable
        public Map<String, Parameter> getParameters() {
            return this.parameters;
        }

        @Nullable
        public Metadata getMetadata() {
            return this.metadata;
        }

        public boolean equals(@Nullable java.lang.Object obj) {
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expression, this.parameters, this.metadata);
        }

        public String toString() {
            return "Condition[name=" + this.name + ", expression=" + this.expression + ", parameters=" + String.valueOf(this.parameters) + ", metadata=" + String.valueOf(this.metadata) + "]";
        }

        public static final class Builder {
            private String name;
            private String expression;
            private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
            @Nullable
            private Metadata metadata;

            private Builder() {
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder parameters(Map<String, Parameter> parameters) {
                this.parameters = new HashMap<String, Parameter>(parameters);
                return this;
            }

            public Builder addParameters(Map<String, Parameter> parameters) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Parameter>();
                }
                this.parameters.putAll(parameters);
                return this;
            }

            public Builder addParameter(String name, Parameter parameter) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Parameter>();
                }
                this.parameters.put(name, parameter);
                return this;
            }

            public Builder addParameter(String name, Parameter.TypeName typeName) {
                return this.addParameter(name, Parameter.builder().typeName(typeName).build());
            }

            public Builder addParameter(String name, Parameter.TypeName typeName, Collection<Parameter.GenericType> genericTypes) {
                return this.addParameter(name, Parameter.builder().typeName(typeName).genericTypes(genericTypes).build());
            }

            public Builder metadata(Metadata metadata) {
                this.metadata = metadata;
                return this;
            }

            public Condition build() {
                return new Condition(this.name, this.expression, this.parameters, this.metadata);
            }
        }

        public static final class Metadata {
            @Nullable
            private final String sourceInfo;
            @Nullable
            private final String module;
            private final Map<String, java.lang.Object> extra;

            public static Builder builder() {
                return new Builder();
            }

            @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
            Metadata(@JsonProperty(value="source_info") @Nullable String sourceInfo, @JsonProperty(value="module") @Nullable String module, @JsonAnySetter @Nullable Map<String, java.lang.Object> extra) {
                this.sourceInfo = Strings.emptyToNull(sourceInfo);
                this.module = Strings.emptyToNull(module);
                this.extra = Optional.ofNullable(extra).map(HashMap::new).orElseGet(HashMap::new);
            }

            @JsonProperty(value="source_info")
            @Nullable
            public String getSourceInfo() {
                return this.sourceInfo;
            }

            @Nullable
            public String getModule() {
                return this.module;
            }

            @JsonAnyGetter
            public Map<String, java.lang.Object> getExtra() {
                return this.extra;
            }

            public boolean equals(@Nullable java.lang.Object obj) {
                if (!(obj instanceof Metadata)) {
                    return false;
                }
                Metadata that = (Metadata)obj;
                return Objects.equals(this.sourceInfo, that.sourceInfo) && Objects.equals(this.module, that.module) && Objects.equals(this.extra, that.extra);
            }

            public int hashCode() {
                return Objects.hash(this.sourceInfo, this.module, this.extra);
            }

            public String toString() {
                return "Metadata[sourceInfo=" + this.sourceInfo + ", module=" + this.module + ",extra=" + String.valueOf(this.extra) + "]";
            }

            public static final class Builder {
                @Nullable
                private String sourceInfo;
                @Nullable
                private String module;
                private final Map<String, java.lang.Object> extra = new HashMap<String, java.lang.Object>();

                private Builder() {
                }

                public Builder sourceInfo(@Nullable String sourceInfo) {
                    this.sourceInfo = sourceInfo;
                    return this;
                }

                public Builder module(@Nullable String module) {
                    this.module = module;
                    return this;
                }

                public Builder extra(@Nullable Map<String, java.lang.Object> extra) {
                    if (extra == null) {
                        this.extra.clear();
                        return this;
                    }
                    this.extra.putAll(extra);
                    return this;
                }

                public Builder addExtra(@Nullable Map<String, java.lang.Object> extra) {
                    if (extra == null) {
                        return this;
                    }
                    this.extra.putAll(extra);
                    return this;
                }

                public Builder addExtra(String key, java.lang.Object value) {
                    this.extra.put(key, value);
                    return this;
                }

                public Metadata build() {
                    return new Metadata(this.sourceInfo, this.module, this.extra);
                }
            }
        }

        public static final class Parameter {
            private final TypeName typeName;
            private final Collection<GenericType> genericTypes = new ArrayList<GenericType>();

            public static Builder builder() {
                return new Builder();
            }

            @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
            Parameter(@JsonProperty(value="type_name") TypeName typeName, @JsonProperty(value="generic_types") Collection<GenericType> genericTypes) {
                this.typeName = Preconditions.parameterNonNull(typeName, "typeName");
                this.genericTypes.addAll(Preconditions.parameterNonNull(genericTypes, "genericTypes"));
            }

            @JsonProperty(value="type_name")
            public TypeName getTypeName() {
                return this.typeName;
            }

            @JsonProperty(value="generic_types")
            public Collection<GenericType> getGenericTypes() {
                return this.genericTypes;
            }

            public boolean equals(java.lang.Object obj) {
                if (!(obj instanceof Parameter)) {
                    return false;
                }
                Parameter that = (Parameter)obj;
                return Objects.equals((java.lang.Object)this.typeName, (java.lang.Object)that.typeName) && Objects.equals(this.genericTypes, that.genericTypes);
            }

            public int hashCode() {
                return Objects.hash(new java.lang.Object[]{this.typeName, this.genericTypes});
            }

            public String toString() {
                return "Parameter[typeName=" + String.valueOf((java.lang.Object)this.typeName) + ", genericTypes=" + String.valueOf(this.genericTypes) + "]";
            }

            public static class Builder {
                private TypeName typeName;
                private Collection<GenericType> genericTypes = new ArrayList<GenericType>();

                private Builder() {
                }

                public Builder typeName(TypeName typeName) {
                    this.typeName = typeName;
                    return this;
                }

                public Builder genericTypes(@Nullable Collection<GenericType> genericTypes) {
                    if (genericTypes == null) {
                        this.genericTypes.clear();
                        return this;
                    }
                    if (this.genericTypes == null) {
                        this.genericTypes = new ArrayList<GenericType>();
                        return this;
                    }
                    this.genericTypes.addAll(genericTypes);
                    return this;
                }

                public Builder addGenericTypes(@Nullable Collection<GenericType> genericTypes) {
                    if (genericTypes == null) {
                        return this;
                    }
                    if (this.genericTypes == null) {
                        this.genericTypes = new ArrayList<GenericType>();
                    }
                    this.genericTypes.addAll(genericTypes);
                    return this;
                }

                public Builder addGenericType(GenericType genericType) {
                    if (this.genericTypes == null) {
                        this.genericTypes = new ArrayList<GenericType>();
                    }
                    this.genericTypes.add(genericType);
                    return this;
                }

                public Parameter build() {
                    return new Parameter(this.typeName, this.genericTypes);
                }
            }

            public static enum TypeName {
                UNSPECIFIED("TYPE_NAME_UNSPECIFIED"),
                ANY("TYPE_NAME_ANY"),
                BOOL("TYPE_NAME_BOOL"),
                STRING("TYPE_NAME_STRING"),
                INT("TYPE_NAME_INT"),
                UINT("TYPE_NAME_UINT"),
                DOUBLE("TYPE_NAME_DOUBLE"),
                DURATION("TYPE_NAME_DURATION"),
                TIMESTAMP("TYPE_NAME_TIMESTAMP"),
                MAP("TYPE_NAME_MAP"),
                LIST("TYPE_NAME_LIST"),
                IPADDRESS("TYPE_NAME_IPADDRESS"),
                UNKNOWN("");

                private final String value;

                private TypeName(String value) {
                    this.value = value;
                }

                @JsonValue
                public String getValue() {
                    return this.value;
                }

                @JsonCreator
                public static TypeName fromValue(String value) {
                    for (TypeName e : TypeName.values()) {
                        if (!e.value.equals(value)) continue;
                        return e;
                    }
                    return UNKNOWN;
                }
            }

            public static class GenericType
            extends HashMap<String, java.lang.Object> {
                private GenericType(Map<String, java.lang.Object> map) {
                    super(map);
                }
            }
        }
    }

    public record Object(String type, String id) {
        public Object {
            Preconditions.parameterNonBlank("type", type);
            Preconditions.parameterNonBlank("id", id);
        }

        public RelObject asRel() {
            return RelObject.of(this.type, this.id);
        }
    }

    public record TypedWildcard(String type) {
        public TypedWildcard {
            Preconditions.parameterNonBlank("type", type);
        }

        public RelObjectType asRel() {
            return RelObjectType.of(this.type);
        }
    }

    public record UsersetUser(String type, String id, String relation) {
        public UsersetUser {
            Preconditions.parameterNonBlank("type", type);
            Preconditions.parameterNonBlank("id", id);
            Preconditions.parameterNonBlank("relation", relation);
        }

        public RelUser asRel() {
            return RelUser.of(this.type, this.id, this.relation);
        }
    }

    public record User(@Nullable Object object, @Nullable UsersetUser userset, @Nullable TypedWildcard wildcard) {
        public User {
            Preconditions.oneOfNonNull("User must have exactly one of object, userset, or wildcard", object, userset, wildcard);
        }

        public RelTyped asRel() {
            if (this.object != null) {
                return RelUser.of(this.object.type(), this.object.id());
            }
            if (this.userset != null) {
                return this.userset.asRel();
            }
            if (this.wildcard != null) {
                return this.wildcard.asRel();
            }
            throw new IllegalStateException("User contains no object, userset, or wildcard");
        }
    }

    public record Userset(@JsonProperty(value="this") @Nullable DirectUserset self_, @Nullable ObjectRelation computedUserset, @Nullable V1.TupleToUserset tupleToUserset, @Nullable Usersets union, @Nullable Usersets intersection, @Nullable V1.Difference difference) {
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public static class DirectUserset {
        private static final DirectUserset INSTANCE = new DirectUserset();

        @JsonCreator
        public static DirectUserset instance() {
            return INSTANCE;
        }
    }

    public record ObjectRelation(@Nullable String object, @Nullable String relation) {
        public ObjectRelation(@Nullable String object, @Nullable String relation) {
            this.object = Strings.emptyToNull(object);
            this.relation = Strings.emptyToNull(relation);
        }
    }

    public static interface V1 {

        public record Difference(Userset base, Userset subtract) {
            public Difference {
                Preconditions.parameterNonNull(base, "base");
                Preconditions.parameterNonNull(subtract, "subtract");
            }
        }

        public record TupleToUserset(ObjectRelation tupleset, ObjectRelation computedUserset) {
            public TupleToUserset {
                Preconditions.parameterNonNull(tupleset, "tupleset");
                Preconditions.parameterNonNull(computedUserset, "computedUserset");
            }
        }
    }

    public record Usersets(Collection<Userset> child) {
        public Usersets {
            Preconditions.parameterNonNull(child, "child");
        }
    }

    public record UsersetTree(@Nullable Node root) {

        public record Node(String name, @Nullable Leaf leaf, @Nullable Difference difference, @Nullable Nodes union, @Nullable Nodes intersection) {
        }

        public record Nodes(Collection<? extends Node> nodes) {
            public Nodes {
                Preconditions.parameterNonNull(nodes, "nodes");
            }
        }

        public record Difference(Node base, Node subtract) {
            public Difference {
                Preconditions.parameterNonNull(base, "base");
                Preconditions.parameterNonNull(subtract, "subtract");
            }
        }

        public record TupleToUserset(String tupleset, Collection<Computed> computed) {
            public TupleToUserset {
                Preconditions.parameterNonBlank("tupleset", tupleset);
                Preconditions.parameterNonNull(computed, "computed");
            }
        }

        public record Computed(String userset) {
            public Computed {
                Preconditions.parameterNonBlank("userset", userset);
            }
        }

        public record Leaf(@Nullable Users users, @Nullable Computed computed, @Nullable TupleToUserset tupleToUserset) {
        }
    }

    public record Users(Collection<String> users) {
        public Users {
            Preconditions.parameterNonNull(users, "users");
        }

        public Collection<RelUser> asRel() {
            return this.users.stream().map(RelUser::valueOf).toList();
        }
    }
}

