/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelEntity;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonDeserialize
public final class RelUser
implements RelEntity {
    private final RelObject object;
    @Nullable
    private final String relation;

    public static RelUser valueOf(String value) {
        String[] parts = value.split("#", 2);
        RelObject object = RelObject.valueOf(parts[0]);
        String relation = null;
        if (parts.length == 2) {
            relation = parts[1];
        }
        return RelUser.of(object, relation);
    }

    public static RelUser of(String type, String id) {
        return RelUser.of(type, id, null);
    }

    public static RelUser of(RelObject object) {
        return RelUser.of(object.getType(), object.getId());
    }

    public static RelUser of(String type, String id, @Nullable String relation) {
        return new RelUser(RelObject.of(type, id), relation);
    }

    public static RelUser of(RelObject object, @Nullable String relation) {
        return new RelUser(Preconditions.parameterNonNull(object, "object"), relation);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelUser(@JsonProperty RelObject object, @JsonProperty @Nullable String relation) {
        this.object = object;
        this.relation = relation;
    }

    @Override
    public String getType() {
        return this.object.getType();
    }

    @Override
    public String getId() {
        return this.object.getId();
    }

    @Nullable
    public String getRelation() {
        return this.relation;
    }

    @Override
    public RelObject asObject() {
        return this.object;
    }

    @Override
    public RelUser asUser() {
        return this;
    }

    public RelTupleDefinition define(String relation, RelObject object) {
        return this.define().relation(relation).object(object).build();
    }

    public RelTupleDefinition.Builder define() {
        return RelTupleDefinition.builder().user(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RelUser)) {
            return false;
        }
        RelUser that = (RelUser)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation);
    }

    public String toString() {
        if (this.relation == null) {
            return this.object.toString();
        }
        return String.valueOf(this.object) + "#" + this.relation;
    }
}

