/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelCondition;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelPartialTupleKey;
import io.quarkiverse.openfga.client.model.RelPartialTupleKeyed;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.RelTupleKey;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.json.RelTupleKeyedDeserializer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonDeserialize(using=RelTupleKeyedDeserializer.class)
public interface RelTupleKeyed
extends RelPartialTupleKeyed {
    @Override
    public RelObject getObject();

    @Override
    public String getRelation();

    public RelUser getUser();

    default public RelTupleKey key() {
        return RelTupleKey.builder().object(this.getObject()).relation(this.getRelation()).user(this.getUser()).build();
    }

    default public RelPartialTupleKey relationship() {
        return RelPartialTupleKey.builder().object(this.getObject()).relation(this.getRelation()).build();
    }

    default public RelTupleDefinition conditional() {
        return RelTupleDefinition.builder().object(this.getObject()).relation(this.getRelation()).user(this.getUser()).build();
    }

    default public RelTupleDefinition withCondition(RelCondition condition) {
        return RelTupleDefinition.builder().object(this.getObject()).relation(this.getRelation()).user(this.getUser()).condition(condition).build();
    }
}

