/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelCondition;
import io.quarkiverse.openfga.client.model.RelEntity;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonDeserialize
public final class RelTupleKey
implements RelTupleKeyed {
    private final RelObject object;
    private final String relation;
    private final RelUser user;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelTupleKey(RelObject object, String relation, RelUser user) {
        this.object = object;
        this.relation = relation;
        this.user = user;
    }

    @Override
    public RelObject getObject() {
        return this.object;
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    @Override
    public RelUser getUser() {
        return this.user;
    }

    @Override
    public RelTupleDefinition withCondition(@Nullable RelCondition condition) {
        return RelTupleDefinition.builder().object(this.object).relation(this.relation).user(this.user).condition(condition).build();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RelTupleKey)) {
            return false;
        }
        RelTupleKey that = (RelTupleKey)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation, this.user);
    }

    public String toString() {
        return "TupleKey[object=" + String.valueOf(this.object) + ", relation=" + this.relation + ", user=" + String.valueOf(this.user) + "]";
    }

    public static final class Builder {
        @Nullable
        private RelEntity object;
        @Nullable
        private String relation;
        @Nullable
        private RelEntity user;

        private Builder() {
        }

        public Builder object(RelEntity object) {
            this.object = object;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public Builder user(RelEntity user) {
            this.user = user;
            return this;
        }

        public RelTupleKey build() {
            RelObject object = Preconditions.parameterNonNull(this.object, "object").asObject();
            String relation = Preconditions.parameterNonNull(this.relation, "relation");
            RelUser user = Preconditions.parameterNonNull(this.user, "user").asUser();
            return new RelTupleKey(object, relation, user);
        }
    }
}

