/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelCondition;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonDeserialize
public final class RelTupleDefinition
implements RelTupleKeyed {
    private final RelObject object;
    private final String relation;
    private final RelUser user;
    @Nullable
    private final RelCondition condition;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelTupleDefinition(RelObject object, String relation, RelUser user, @Nullable RelCondition condition) {
        this.object = object;
        this.relation = relation;
        this.user = user;
        this.condition = condition;
    }

    @Override
    public RelObject getObject() {
        return this.object;
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    @Override
    public RelUser getUser() {
        return this.user;
    }

    @Nullable
    public RelCondition getCondition() {
        return this.condition;
    }

    @Override
    public RelTupleDefinition conditional() {
        return this;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RelTupleDefinition)) {
            return false;
        }
        RelTupleDefinition that = (RelTupleDefinition)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.user, that.user) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation, this.user, this.condition);
    }

    public String toString() {
        return "ConditionalTupleKey[object=" + String.valueOf(this.object) + ", relation=" + this.relation + ", user=" + String.valueOf(this.user) + ", condition=" + String.valueOf(this.condition) + "]";
    }

    public static final class Builder {
        @Nullable
        private RelObject object;
        @Nullable
        private String relation;
        @Nullable
        private RelUser user;
        @Nullable
        private RelCondition condition;

        private Builder() {
        }

        public Builder object(RelObject object) {
            this.object = object;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public Builder user(RelUser user) {
            this.user = user;
            return this;
        }

        public Builder condition(@Nullable RelCondition condition) {
            this.condition = condition;
            return this;
        }

        public RelTupleDefinition build() {
            RelObject object = Preconditions.parameterNonNull(this.object, "object");
            String relation = Preconditions.parameterNonNull(this.relation, "relation");
            RelUser user = Preconditions.parameterNonNull(this.user, "user");
            return new RelTupleDefinition(object, relation, user, this.condition);
        }
    }
}

