/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.TupleOperation;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RelTupleChange {
    private final RelTupleDefinition tupleKey;
    private final TupleOperation operation;
    private final OffsetDateTime timestamp;

    public static RelTupleChange of(RelTupleDefinition tupleKey, TupleOperation operation, OffsetDateTime timestamp) {
        return new RelTupleChange(tupleKey, operation, timestamp);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelTupleChange(@JsonProperty(value="tuple_key") RelTupleDefinition tupleKey, TupleOperation operation, OffsetDateTime timestamp) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.operation = Preconditions.parameterNonNull(operation, "operation");
        this.timestamp = Preconditions.parameterNonNull(timestamp, "timestamp");
    }

    @JsonProperty(value="tuple_key")
    public RelTupleDefinition getTupleKey() {
        return this.tupleKey;
    }

    public TupleOperation getOperation() {
        return this.operation;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof RelTupleChange)) {
            return false;
        }
        RelTupleChange that = (RelTupleChange)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals((Object)this.operation, (Object)that.operation) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.operation, this.timestamp});
    }

    public String toString() {
        return "TupleChange[tupleKey=" + String.valueOf(this.tupleKey) + ", operation=" + String.valueOf((Object)this.operation) + ", timestamp=" + String.valueOf(this.timestamp) + "]";
    }
}

