/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RelTuple {
    private final RelTupleDefinition key;
    private final OffsetDateTime timestamp;

    public static RelTuple of(RelTupleDefinition key, OffsetDateTime timestamp) {
        return new RelTuple(key, timestamp);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelTuple(RelTupleDefinition key, OffsetDateTime timestamp) {
        this.key = Preconditions.parameterNonNull(key, "key");
        this.timestamp = Preconditions.parameterNonNull(timestamp, "timestamp");
    }

    public RelTupleDefinition getKey() {
        return this.key;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof RelTuple)) {
            return false;
        }
        RelTuple that = (RelTuple)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.timestamp);
    }

    public String toString() {
        return "Tuple[key=" + String.valueOf(this.key) + ", timestamp=" + String.valueOf(this.timestamp) + "]";
    }
}

