/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelPartialTupleKeyed;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonDeserialize
public final class RelPartialTupleKey
implements RelPartialTupleKeyed {
    private final RelObject object;
    private final String relation;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelPartialTupleKey(RelObject object, String relation) {
        this.object = object;
        this.relation = relation;
    }

    @Override
    public RelObject getObject() {
        return this.object;
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RelPartialTupleKey that = (RelPartialTupleKey)obj;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return Objects.hash(this.relation, this.object);
    }

    public String toString() {
        return "TupleKey[relation=" + this.relation + ", object=" + String.valueOf(this.object) + ", ]";
    }

    public static final class Builder {
        @Nullable
        private RelObject object;
        @Nullable
        private String relation;

        private Builder() {
        }

        public Builder object(RelObject object) {
            this.object = object;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public RelPartialTupleKey build() {
            return new RelPartialTupleKey(Preconditions.parameterNonNull(this.object, "object"), Preconditions.parameterNonNull(this.relation, "relation"));
        }
    }
}

