/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.openfga.client.model.RelObject;
import io.quarkiverse.openfga.client.model.RelTyped;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RelObjectType
implements RelTyped {
    public static final String WILDCARD_TYPE_NAME = "*";
    public static final RelObjectType ANY = new RelObjectType("*");
    private final String type;

    public static RelObjectType of(String type) {
        if (type.equals(WILDCARD_TYPE_NAME)) {
            return ANY;
        }
        return new RelObjectType(type);
    }

    @JsonCreator
    public static RelObjectType valueOf(String value) {
        String[] parts = value.split(":", 2);
        String type = parts[0];
        if (parts.length == 2 && !parts[1].equals(WILDCARD_TYPE_NAME) && !parts[1].isBlank()) {
            throw new IllegalArgumentException("Invalid object type: %s. Id must be empty or '%s'".formatted(value, WILDCARD_TYPE_NAME));
        }
        return RelObjectType.of(type);
    }

    private RelObjectType(String type) {
        this.type = Preconditions.parameterNonBlank(type, "type");
    }

    @Override
    public String getType() {
        return this.type;
    }

    public RelObject toObject(String id) {
        return RelObject.of(this.type, id);
    }

    public RelUser toUser(String id) {
        return RelUser.of(this.type, id);
    }

    public RelUser toUser(String id, @Nullable String relation) {
        return RelUser.of(this.type, id, relation);
    }

    @Override
    public RelObjectType asType() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RelObjectType that = (RelObjectType)obj;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @JsonValue
    public String toString() {
        return this.type + ":";
    }
}

