/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.openfga.client.model.RelEntity;
import io.quarkiverse.openfga.client.model.RelTupleDefinition;
import io.quarkiverse.openfga.client.model.RelUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;

@JsonDeserialize
public final class RelObject
implements RelEntity {
    private final String type;
    private final String id;

    public static RelObject valueOf(String value) {
        String[] parts = value.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid typed object: " + value);
        }
        return RelObject.of(parts[0], parts[1]);
    }

    public static RelObject of(String type, String id) {
        return new RelObject(Preconditions.parameterNonBlank(type, "type"), Preconditions.parameterNonBlank(id, "id"));
    }

    public static RelObject typeOnly(String type) {
        return new RelObject(type, "");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelObject(@JsonProperty String type, @JsonProperty String id) {
        this.type = type;
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public RelObject withType(String type) {
        return RelObject.of(type, this.id);
    }

    public RelObject withId(String id) {
        return RelObject.of(this.type, id);
    }

    @Override
    public RelObject asObject() {
        return this;
    }

    public RelTupleDefinition define(String relation, RelUser user) {
        return this.define().relation(relation).user(user).build();
    }

    public RelTupleDefinition.Builder define() {
        return RelTupleDefinition.builder().object(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RelObject)) {
            return false;
        }
        RelObject that = (RelObject)obj;
        return Objects.equals(this.type, that.getType()) && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public String toString() {
        return this.type + ":" + this.id;
    }
}

