/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class RelCondition {
    private final String name;
    @Nullable
    private final Map<String, Object> context;

    public static RelCondition of(String name, @Nullable Map<String, Object> context) {
        return new RelCondition(name, context);
    }

    public static RelCondition of(String name) {
        return RelCondition.of(name, null);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelCondition(String name, @Nullable Map<String, Object> context) {
        this.name = Preconditions.parameterNonBlank(name, "name");
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof RelCondition)) {
            return false;
        }
        RelCondition that = (RelCondition)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.context);
    }

    public String toString() {
        return "RelCondition[name=" + this.name + ", context=" + String.valueOf(this.context) + "]";
    }
}

