/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Schema;
import io.quarkiverse.openfga.client.model.utils.Maps;
import io.quarkiverse.openfga.client.model.utils.ModelMapper;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuthorizationModelSchema {
    public static final String DEFAULT_SCHEMA_VERSION = "1.1";
    private final String schemaVersion;
    private final List<Schema.TypeDefinition> typeDefinitions;
    @Nullable
    private final Map<String, Schema.Condition> conditions;

    public static Builder builder() {
        return new Builder();
    }

    public static AuthorizationModelSchema parse(InputStream stream) throws IOException {
        return (AuthorizationModelSchema)ModelMapper.mapper.readValue(stream, AuthorizationModelSchema.class);
    }

    public static AuthorizationModelSchema parse(Reader reader) throws IOException {
        return (AuthorizationModelSchema)ModelMapper.mapper.readValue(reader, AuthorizationModelSchema.class);
    }

    public static AuthorizationModelSchema parse(byte[] bytes) throws IOException {
        return (AuthorizationModelSchema)ModelMapper.mapper.readValue(bytes, AuthorizationModelSchema.class);
    }

    public static AuthorizationModelSchema parse(String json) throws IOException {
        return (AuthorizationModelSchema)ModelMapper.mapper.readValue(json, AuthorizationModelSchema.class);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    AuthorizationModelSchema(@JsonProperty(value="schema_version") String schemaVersion, @JsonProperty(value="type_definitions") List<Schema.TypeDefinition> typeDefinitions, @Nullable Map<String, Schema.Condition> conditions) {
        this.schemaVersion = schemaVersion;
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
        this.conditions = Maps.emptyToNull(conditions);
    }

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type_definitions")
    public List<Schema.TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @Nullable
    public Map<String, Schema.Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof AuthorizationModelSchema)) {
            return false;
        }
        AuthorizationModelSchema that = (AuthorizationModelSchema)obj;
        return this.schemaVersion.equals(that.schemaVersion) && this.typeDefinitions.equals(that.typeDefinitions) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        int result = this.schemaVersion.hashCode();
        result = 31 * result + this.typeDefinitions.hashCode();
        result = 31 * result + Objects.hashCode(this.conditions);
        return result;
    }

    public String toString() {
        return "AuthorizationModelSchema[schemaVersion=" + this.schemaVersion + ", typeDefinitions=" + String.valueOf(this.typeDefinitions) + ", conditions=" + String.valueOf(this.conditions) + "]";
    }

    public static final class Builder {
        private String schemaVersion = "1.1";
        private List<Schema.TypeDefinition> typeDefinitions = new ArrayList<Schema.TypeDefinition>();
        @Nullable
        private Map<String, Schema.Condition> conditions;

        private Builder() {
        }

        public Builder schemaVersion(@Nullable String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder typeDefinitions(@Nullable Collection<Schema.TypeDefinition> typeDefinitions) {
            if (typeDefinitions == null) {
                return this;
            }
            this.typeDefinitions = new ArrayList<Schema.TypeDefinition>(typeDefinitions);
            return this;
        }

        public Builder addTypeDefinitions(Schema.TypeDefinition ... typeDefinitions) {
            return this.typeDefinitions(List.of(typeDefinitions));
        }

        public Builder addTypeDefinition(Schema.TypeDefinition typeDefinition) {
            this.typeDefinitions.add(typeDefinition);
            return this;
        }

        public Builder conditions(@Nullable Map<String, Schema.Condition> conditions) {
            if (conditions == null) {
                this.conditions = null;
                return this;
            }
            this.conditions = new HashMap<String, Schema.Condition>(conditions);
            return this;
        }

        public Builder addCondition(String name, Schema.Condition condition) {
            if (this.conditions == null) {
                this.conditions = new HashMap<String, Schema.Condition>();
            }
            this.conditions.put(name, condition);
            return this;
        }

        public AuthorizationModelSchema build() {
            return new AuthorizationModelSchema(this.schemaVersion, this.typeDefinitions, this.conditions);
        }
    }
}

