/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Schema;
import io.quarkiverse.openfga.client.model.utils.Maps;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuthorizationModel {
    private final String id;
    private final String schemaVersion;
    private final List<Schema.TypeDefinition> typeDefinitions;
    @Nullable
    private final Map<String, Schema.Condition> conditions;

    public AuthorizationModel of(String id, String schemaVersion, List<Schema.TypeDefinition> typeDefinitions, @Nullable Map<String, Schema.Condition> conditions) {
        return new AuthorizationModel(id, schemaVersion, typeDefinitions, conditions);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    AuthorizationModel(String id, @JsonProperty(value="schema_version") String schemaVersion, @JsonProperty(value="type_definitions") List<Schema.TypeDefinition> typeDefinitions, @JsonProperty(value="conditions") @Nullable Map<String, Schema.Condition> conditions) {
        this.id = Preconditions.parameterNonNull(id, "id");
        this.schemaVersion = Preconditions.parameterNonNull(schemaVersion, "schemaVersion");
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
        this.conditions = Maps.emptyToNull(conditions);
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type_definitions")
    public List<Schema.TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="conditions")
    @Nullable
    public Map<String, Schema.Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof AuthorizationModel)) {
            return false;
        }
        AuthorizationModel that = (AuthorizationModel)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.typeDefinitions, that.typeDefinitions) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.typeDefinitions, this.conditions);
    }

    public String toString() {
        return "AuthorizationModel[id=" + this.id + ", typeDefinitions=" + String.valueOf(this.typeDefinitions) + ", conditions=" + String.valueOf(this.conditions) + "]";
    }
}

