/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Assertion {
    private final RelTupleKeyed tupleKey;
    private final boolean expectation;
    @Nullable
    private final Collection<RelTupleKeyed> contextualTuples;
    private final Map<String, Object> context;

    public static Assertion of(RelTupleKeyed tupleKey, boolean expectation, @Nullable List<RelTupleKeyed> contextualTuples, @Nullable Map<String, Object> context) {
        return new Assertion(tupleKey, expectation, contextualTuples, context);
    }

    public static Assertion of(RelTupleKeyed tupleKey, boolean expectation) {
        return new Assertion(tupleKey, expectation, null, null);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Assertion(@JsonProperty(value="tuple_key") RelTupleKeyed tupleKey, boolean expectation, @JsonProperty(value="contextual_tuples") @Nullable Collection<RelTupleKeyed> contextualTuples, @Nullable Map<String, Object> context) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.expectation = expectation;
        this.contextualTuples = contextualTuples;
        this.context = context;
    }

    @JsonProperty(value="tuple_key")
    @JsonSerialize(typing=JsonSerialize.Typing.STATIC)
    public RelTupleKeyed getTupleKey() {
        return this.tupleKey;
    }

    public boolean getExpectation() {
        return this.expectation;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonSerialize(typing=JsonSerialize.Typing.STATIC)
    @Nullable
    public Collection<RelTupleKeyed> getContextualTuples() {
        return this.contextualTuples;
    }

    @Nullable
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Assertion)) {
            return false;
        }
        Assertion that = (Assertion)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && this.expectation == that.expectation && Objects.equals(this.contextualTuples, that.contextualTuples);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.expectation, this.contextualTuples);
    }

    public String toString() {
        return "Assertion[tupleKey=" + String.valueOf(this.tupleKey) + ", expectation=" + this.expectation + ", contextualTuples=" + String.valueOf(this.contextualTuples) + "]";
    }
}

