/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.PartialTupleKey;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReadRequest {
    @JsonProperty(value="tuple_key")
    @Nullable
    private final PartialTupleKey tupleKey;
    @JsonProperty(value="authorization_model_id")
    @Nullable
    private final String authorizationModelId;
    @JsonProperty(value="page_size")
    @Nullable
    private final Integer pageSize;
    @JsonProperty(value="continuation_token")
    @Nullable
    private final String continuationToken;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ReadRequest(@JsonProperty(value="tuple_key") @Nullable PartialTupleKey tupleKey, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @JsonProperty(value="page_size") @Nullable Integer pageSize, @JsonProperty(value="continuation_token") @Nullable String continuationToken) {
        this.tupleKey = tupleKey;
        this.authorizationModelId = authorizationModelId;
        this.pageSize = pageSize;
        this.continuationToken = continuationToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="tuple_key")
    @Nullable
    public PartialTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="page_size")
    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="continuation_token")
    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ReadRequest that = (ReadRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.continuationToken, that.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.authorizationModelId, this.pageSize, this.continuationToken);
    }

    public String toString() {
        return "ReadRequest{tupleKey=" + this.tupleKey + ", authorizationModelId='" + this.authorizationModelId + "', pageSize=" + this.pageSize + ", continuationToken='" + this.continuationToken + "'}";
    }

    public static final class Builder {
        private PartialTupleKey tupleKey;
        private String authorizationModelId;
        private Integer pageSize;
        private String continuationToken;

        public Builder tupleKey(@Nullable PartialTupleKey tupleKey) {
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public ReadRequest build() {
            return new ReadRequest(this.tupleKey, this.authorizationModelId, this.pageSize, this.continuationToken);
        }
    }
}

