/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.AnyObject;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.ContextualTupleKeys;
import io.quarkiverse.openfga.client.model.UserTypeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ListUsersRequest {
    @JsonProperty(value="authorization_model_id")
    @Nullable
    private final String authorizationModelId;
    private final AnyObject object;
    private final String relation;
    @JsonProperty(value="user_filters")
    private final List<UserTypeFilter> userFilters;
    @JsonProperty(value="contextual_tuples")
    @Nullable
    private final ContextualTupleKeys contextualTuples;
    @Nullable
    private final Object context;
    @Nullable
    private final ConsistencyPreference consistency;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ListUsersRequest(@JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, AnyObject object, String relation, List<UserTypeFilter> userFilters, @Nullable @JsonProperty(value="contextual_tuples") ContextualTupleKeys contextualTuples, @Nullable Object context, @Nullable ConsistencyPreference consistency) {
        this.authorizationModelId = authorizationModelId;
        this.object = object;
        this.relation = relation;
        this.userFilters = userFilters;
        this.contextualTuples = contextualTuples;
        this.context = context;
        this.consistency = consistency;
    }

    public static ListUsersRequest of(@Nullable String authorizationModelId, AnyObject object, String relation, List<UserTypeFilter> userFilters, @Nullable ContextualTupleKeys contextualTuples, @Nullable Object context, @Nullable ConsistencyPreference consistency) {
        return new ListUsersRequest(authorizationModelId, object, relation, userFilters, contextualTuples, context, consistency);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public AnyObject getObject() {
        return this.object;
    }

    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="user_filters")
    public List<UserTypeFilter> getUserFilters() {
        return this.userFilters;
    }

    @JsonProperty(value="contextual_tuples")
    @Nullable
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @Nullable
    public Object getContext() {
        return this.context;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ListUsersRequest that = (ListUsersRequest)obj;
        return Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.userFilters, that.userFilters) && Objects.equals(this.contextualTuples, that.contextualTuples) && Objects.equals(this.context, that.context) && Objects.equals((Object)this.consistency, (Object)that.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationModelId, this.object, this.relation, this.userFilters, this.contextualTuples, this.context, this.consistency});
    }

    public String toString() {
        return "ListObjectsRequest[authorizationModelId=" + this.authorizationModelId + ", object=" + this.object + ", relation=" + this.relation + ", userFilters=" + this.userFilters + ", contextualTupleKeys=" + this.contextualTuples + ", context=" + this.context + ", consistency=" + this.consistency + "]";
    }

    public static final class Builder {
        private String authorizationModelId;
        private AnyObject object;
        private String relation;
        private List<UserTypeFilter> userFilters;
        private ContextualTupleKeys contextualTuples;
        private Object context;
        private ConsistencyPreference consistency;

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder object(AnyObject object) {
            this.object = object;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public Builder userFilters(List<UserTypeFilter> userFilters) {
            this.userFilters = userFilters;
            return this;
        }

        public Builder addUserFilters(List<UserTypeFilter> userFilters) {
            if (this.userFilters == null) {
                this.userFilters = new ArrayList<UserTypeFilter>();
            }
            this.userFilters.addAll(userFilters);
            return this;
        }

        public Builder addUserFilter(UserTypeFilter userFilter) {
            if (this.userFilters == null) {
                this.userFilters = new ArrayList<UserTypeFilter>();
            }
            this.userFilters.add(userFilter);
            return this;
        }

        public Builder contextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Builder addContextualTuples(List<ConditionalTupleKey> contextualTuples) {
            if (this.contextualTuples == null) {
                this.contextualTuples = ContextualTupleKeys.of(new ArrayList<ConditionalTupleKey>());
            }
            this.contextualTuples.getTupleKeys().addAll(contextualTuples);
            return this;
        }

        public Builder addContextualTuple(ConditionalTupleKey contextualTuple) {
            if (this.contextualTuples == null) {
                this.contextualTuples = ContextualTupleKeys.of(new ArrayList<ConditionalTupleKey>());
            }
            this.contextualTuples.getTupleKeys().add(contextualTuple);
            return this;
        }

        public Builder context(@Nullable Object context) {
            this.context = context;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public ListUsersRequest build() {
            return new ListUsersRequest(this.authorizationModelId, this.object, this.relation, this.userFilters, this.contextualTuples, this.context, this.consistency);
        }
    }
}

