/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ListChangesRequest {
    @Nullable
    private final String type;
    @JsonProperty(value="page_size")
    @Nullable
    private final Integer pageSize;
    @JsonProperty(value="continuation_token")
    @Nullable
    private final String continuationToken;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ListChangesRequest(@Nullable String type, @JsonProperty(value="page_size") @Nullable Integer pageSize, @JsonProperty(value="continuation_token") @Nullable String continuationToken) {
        this.type = type;
        this.pageSize = pageSize;
        this.continuationToken = continuationToken;
    }

    public static ListChangesRequest of(@Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken) {
        return new ListChangesRequest(type, pageSize, continuationToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="page_size")
    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="continuation_token")
    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ListChangesRequest that = (ListChangesRequest)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.continuationToken, that.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pageSize, this.continuationToken);
    }

    public String toString() {
        return "ExpandRequest[type=" + this.type + ", pageSize=" + this.pageSize + ", continuationToken=" + this.continuationToken + "]";
    }

    public static final class Builder {
        private String type;
        private Integer pageSize;
        private String continuationToken;

        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Builder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder continuationToken(@Nullable String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public ListChangesRequest build() {
            return new ListChangesRequest(this.type, this.pageSize, this.continuationToken);
        }
    }
}

