/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.ExpandTupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ExpandRequest {
    @JsonProperty(value="tuple_key")
    private final ExpandTupleKey tupleKey;
    @JsonProperty(value="authorization_model_id")
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final ConsistencyPreference consistency;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ExpandRequest(@JsonProperty(value="tuple_key") ExpandTupleKey tupleKey, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @Nullable ConsistencyPreference consistency) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.authorizationModelId = authorizationModelId;
        this.consistency = consistency;
    }

    public static ExpandRequest of(ExpandTupleKey tupleKey, @Nullable String authorizationModelId, @Nullable ConsistencyPreference consistency) {
        return new ExpandRequest(tupleKey, authorizationModelId, consistency);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="tuple_key")
    public ExpandTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ExpandRequest that = (ExpandRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)that.consistency);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.authorizationModelId);
    }

    public String toString() {
        return "ExpandRequest[tupleKey=" + this.tupleKey + ", authorizationModelId=" + this.authorizationModelId + ", consistency=" + this.consistency + "]";
    }

    public static final class Builder {
        private ExpandTupleKey tupleKey;
        private String authorizationModelId;
        private ConsistencyPreference consistency;

        public Builder tupleKey(ExpandTupleKey tupleKey) {
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public ExpandRequest build() {
            return new ExpandRequest(this.tupleKey, this.authorizationModelId, this.consistency);
        }
    }
}

